variable "account_id" {
  type        = string
  default     = "989470033077"
  description = "AWS account id"
}

variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "deployment_batch_size_percentage" {
  type        = string
  description = "Elastic Beanstalk rolling deployment batch size"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "instance_type" {
  type        = string
  description = "EC2 instance type"
}

variable "name" {
  type        = string
  default     = "roster"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "cb/roster"
  description = "GitHub repository name"
}

variable "s3_assets_iam_role_arn" {
  type        = string
  description = "AWS IAM Role ARN of S3 bucket for assets"
}

variable "s3_uploads_iam_role_arn" {
  type        = string
  description = "AWS IAM Role ARN of S3 bucket for asset uploads"
}

variable "sandstorm_iam_role_arn" {
  type        = string
  description = "AWS IAM Role ARN for assuming the role of the Sandstorm Agent"
}

variable "pdms_role_arn" {
  type        = string
  description = "The ARN of the role that's assumed in order to call the PDMS API."
}

variable "pdms_lambda_arn" {
  type        = string
  description = "The ARN for the Lambda for PDMS."
}

variable "solution_stack_name" {
  type    = string
  default = "64bit Amazon Linux 2018.03 v2.16.5 running Docker 19.03.13-ce"
}

variable "team" {
  type    = string
  default = "Creator Business"
}

variable "team_code" {
  type    = string
  default = "cb"
}

variable "hard_delete_user_arn" {
  type        = string
  description = "arn of the hard_delete_user sns topic"
}
