data "aws_caller_identity" "current" {}

module "glue-rds" {
  source          = "git::git+ssh://git@git.xarth.tv/stats/db-s3-glue.git?ref=37210c9b39b39c2f7c85dc43cfa940b4d017ca97"
  database_type   = "rds"
  cluster_name    = var.db_identifier
  job_name        = "${var.db_identifier}-qa"
  qa_for_job_name = var.db_identifier

  table_config = {
    "teams" = <<EOF
{
  "dpu_count": 2,
  "version": 0,
  "spark_optimization": true,
  "schema": [
    {"name": "id", "type": "int"},
    {"name": "name", "type": "string"},
    {"name": "display_name", "type": "string"},
    {"name": "user_id", "type": "int", "sensitivity": "userid"},
    {"name": "info", "type": "string"},
    {"name": "banner_image", "type": "string"},
    {"name": "created_at", "type": "timestamp"},
    {"name": "updated_at", "type": "timestamp"},
    {"name": "background_color", "type": "string"},
    {"name": "background_image", "type": "string"},
    {"name": "background_no_repeat", "type": "boolean"},
    {"name": "team_logo_image", "type": "string"},
    {"name": "short_name", "type": "string"},
    {"name": "status", "type": "string"},
    {"name": "focus_info_tab", "type": "boolean"},
    {"name": "show_chat_tab", "type": "boolean"}
  ]
}
EOF

    "team_streams" = <<EOF
{
  "dpu_count": 2,
  "version": 0,
  "spark_optimization": true,
  "schema": [
    {"name": "id", "type": "int"},
    {"name": "team_id", "type": "int"},
    {"name": "user_id", "type": "int", "sensitivity": "userid"},
    {"name": "display_order", "type": "int"},
    {"name": "created_at", "type": "timestamp"},
    {"name": "updated_at", "type": "timestamp"}
  ]
}
EOF

    "team_users" = <<EOF
{
  "dpu_count": 2,
  "version": 0,
  "spark_optimization": true,
  "schema": [
    {"name": "id", "type": "int"},
    {"name": "team_id", "type": "int"},
    {"name": "user_id", "type": "int", "sensitivity": "userid"},
    {"name": "display_order", "type": "int"},
    {"name": "created_at", "type": "timestamp"},
    {"name": "updated_at", "type": "timestamp"},
    {"name": "view_revenue", "type": "boolean"},
    {"name": "view_stats", "type": "boolean"}
  ]
}
EOF

    "team_invitations" = <<EOF
{
  "dpu_count": 2,
  "version": 0,
  "spark_optimization": true,
  "schema": [
    {"name": "id", "type": "int"},
    {"name": "team_id", "type": "int"},
    {"name": "user_id", "type": "int", "sensitivity": "userid"},
    {"name": "status", "type": "string"},
    {"name": "created_on", "type": "timestamp"},
    {"name": "updated_on", "type": "timestamp"}
  ]
}
EOF
  }

  s3_output_bucket               = "cb-db-exports"
  create_s3_output_bucket        = 0
  s3_output_key                  = "roster"
  s3_output_kms_key_arn          = var.s3_output_kms_key_arn
  s3_script_bucket               = "aws-glue-scripts-${data.aws_caller_identity.current.account_id}-${var.aws_region}"
  create_s3_script_bucket        = 0
  error_sns_topic_name           = ""
  account_number                 = data.aws_caller_identity.current.account_id
  vpc_id                         = data.terraform_remote_state.account.outputs.vpc_id
  subnet_id                      = "${element(split(",", "${data.terraform_remote_state.account.outputs.private_subnets}"), 0)}"
  availability_zone              = var.aws_availability_zone
  rds_subnet_group               = var.db_subnet_group_name
  cluster_username               = "zenyatta"
  db_password_parameter_name     = "/${var.environment}/database/${var.db_identifier}/password/zenyatta"
  db_password_key_id             = var.ssm_kms_key_id

  api_key_parameter_name = "/${var.environment}/database/${var.db_identifier}/password/tahoe_api_key"
  api_key_kms_key_id     = var.ssm_kms_key_id

  tahoe_producer_name = "teamsdbexport"
  tahoe_producer_role_arn = "arn:aws:iam::331582574546:role/producer-teamsdbexport"
}
