variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "aws_availability_zone" {
  type    = string
  default = "us-west-2a"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "name" {
  type        = string
  default     = "roster"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "db_subnet_group_name" {
  type        = string
  description = "Name of the subnet group the DB is in"
}

variable "db_identifier" {
  type        = string
  description = "The identifier for the DB to be used"
}

variable "s3_output_kms_key_arn" {
  type        = string
  description = "arn of the KMS key used by the production job"
}

variable "ssm_kms_key_id" {
  type        = string
  description = "arn of the KMS key used to encrypt SSM variables"
}
