resource "aws_ssm_parameter" "zenyatta" {
  name        = "/${var.environment}/database/${var.db_identifier}/password/zenyatta"
  description = "${var.db_identifier}'s password for user zenyatta"
  type        = "SecureString"
  value       = "temporary"

  lifecycle {
    ignore_changes = [value]
  }

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}

resource "aws_ssm_parameter" "tahoe_api_key" {
  name        = "/${var.environment}/database/${var.db_identifier}/password/tahoe_api_key"
  description = "${var.db_identifier}'s Tahoe producer API key"
  type        = "SecureString"
  value       = "temporary"

  lifecycle {
    ignore_changes = [value]
  }

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}
