resource "aws_cloudwatch_metric_alarm" "api_health" {
  alarm_name                = "${var.elastic_beanstalk_environment_api_name}-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS API"
  insufficient_data_actions = []
  alarm_actions             = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions                = [aws_sns_topic.pagerduty_alerts.arn]

  dimensions = {
    EnvironmentName = var.elastic_beanstalk_environment_api_name
  }
}

resource "aws_cloudwatch_metric_alarm" "worker_health" {
  alarm_name                = "${var.elastic_beanstalk_environment_worker_name}-health"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "2"
  metric_name               = "EnvironmentHealth"
  namespace                 = "AWS/ElasticBeanstalk"
  period                    = "60"
  statistic                 = "Maximum"
  threshold                 = "20" # 20 is degraded health
  alarm_description         = "Monitors the health of this EBS worker"
  insufficient_data_actions = []
  alarm_actions             = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions                = [aws_sns_topic.pagerduty_alerts.arn]

  dimensions = {
    EnvironmentName = var.elastic_beanstalk_environment_worker_name
  }
}

resource "aws_cloudwatch_metric_alarm" "primary_rds_disk_space" {
  alarm_name                = "${var.primary_rds_instance_identifier}-primary-rds-disk-space"
  comparison_operator       = "LessThanThreshold"
  evaluation_periods        = "1"
  metric_name               = "FreeStorageSpace"
  namespace                 = "AWS/RDS"
  period                    = "300"
  statistic                 = "Average"
  threshold                 = "53687091200" # 50 GiB
  alarm_description         = "Monitors the disk space of this primary RDS instance"
  insufficient_data_actions = []
  alarm_actions             = [aws_sns_topic.pagerduty_alerts.arn]
  ok_actions                = [aws_sns_topic.pagerduty_alerts.arn]

  dimensions = {
    DBInstanceIdentifier = var.primary_rds_instance_identifier
  }
}
