resource "aws_db_subnet_group" "roster" {
  name = "${var.team_code}-${var.name}-${var.environment}"

  subnet_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.private_subnets,
  )

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}

resource "aws_db_instance" "primary" {
  engine            = "postgres"
  engine_version    = "9.6.6"
  instance_class    = "db.m4.large"
  storage_type      = "gp2"
  multi_az          = true
  allocated_storage = 100

  identifier = "${var.team_code}-${var.name}-${var.environment}"
  name       = var.name
  username   = "master"
  password   = "temporary"

  lifecycle {
    ignore_changes = [
      password,
      engine_version,
    ]
  }

  publicly_accessible = false

  # From looking at the terraform file - this appears to return a single list item.
  vpc_security_group_ids = [
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  ]

  port                 = 5432
  db_subnet_group_name = aws_db_subnet_group.roster.name
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  backup_retention_period = 1
  backup_window           = "02:00-04:00"

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}

resource "aws_db_instance" "replica" {
  replicate_source_db = aws_db_instance.primary.id

  instance_class    = aws_db_instance.primary.instance_class
  storage_type      = "gp2"
  allocated_storage = aws_db_instance.primary.allocated_storage

  identifier = "${aws_db_instance.primary.id}-replica"
  name       = aws_db_instance.primary.name

  publicly_accessible = false

  # From looking at the terraform file - this appears to return a single list item.
  vpc_security_group_ids = [
    data.terraform_remote_state.account.outputs.twitch_subnets_sg,
  ]

  port                 = aws_db_instance.primary.port
  parameter_group_name = "pg-stat-statements-postgres-9-6"

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }
}

output "db_subnet_group_name" {
  value = aws_db_subnet_group.roster.name
}

output "db_identifier" {
  value = aws_db_instance.primary.identifier
}
