variable "environment" {
}

resource "aws_elasticache_subnet_group" "redis_subnet_group" {
  name        = "cb-roster-${var.environment}"
  description = "Redis subnet group for Roster"

  subnet_ids = split(
    ",",
    data.terraform_remote_state.account.outputs.private_subnets,
  )
}

resource "aws_elasticache_cluster" "redis" {
  cluster_id      = "cb-roster-${var.environment}"
  engine          = "redis"
  node_type       = "cache.m4.xlarge"
  port            = 6379
  num_cache_nodes = 1
  
  # From looking at the terraform file - this appears to return a single list item.
  security_group_ids = [data.terraform_remote_state.account.outputs.twitch_subnets_sg]
  subnet_group_name  = aws_elasticache_subnet_group.redis_subnet_group.name

  tags = {
    environment = var.environment
    name        = "roster"
    owner       = "creatorbusiness@twitch.tv"
    project     = "cb/roster"
    team        = "Creator Business"
  }
}
