resource "aws_s3_bucket" "assets" {
  bucket = "${var.team_code}-${var.name}-${var.environment}-assets"
  acl    = "private"

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }

  logging {
    target_bucket = aws_s3_bucket.logs.id
    target_prefix = "logs/${var.team_code}-${var.name}-${var.environment}-assets/"
  }

  region = var.aws_region
}

output "assets_arn" {
  value = aws_s3_bucket.assets.arn
}
