resource "aws_s3_bucket" "logs" {
  bucket = "${var.team_code}-${var.name}-${var.environment}-s3-logs"
  acl    = "log-delivery-write"

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }

  lifecycle_rule {
    id      = "expire-logs"
    prefix  = "logs/"
    enabled = true

    expiration {
      days = 30
    }
  }

  region = var.aws_region
}
