resource "aws_s3_bucket" "uploads" {
  bucket = var.uploads_bucket_name
  acl    = "private"

  tags = {
    environment = var.environment
    name        = var.name
    owner       = var.owner
    project     = var.project
    team        = var.team
  }

  logging {
    target_bucket = aws_s3_bucket.logs.id
    target_prefix = "logs/${var.uploads_bucket_name}/"
  }

  lifecycle_rule {
    id      = "images"
    enabled = true
    prefix  = "images/"

    expiration {
      days = 1
    }
  }

  region = var.aws_region

  cors_rule {
    allowed_headers = ["*"]
    allowed_methods = ["PUT"]
    allowed_origins = ["https://www.twitch.tv", "*.twitch.tech:8080"]
    max_age_seconds = 6000
  }
}

output "uploads_arn" {
  value = aws_s3_bucket.uploads.arn
}
