# vpc_endpoint

https://git.xarth.tv/chat/terraform/tree/bc28918473f3e23e98ada70ebc132d929123e0ce/modules/vpc_endpoint

This module creates a VPC Endpoint in our AWS account, used to connect to a
service in another account without a peering connection.

`vpc_endpoint_service` is the identifier of the VPC endpoint in the target
account.

`vpc_endpoint_id` is the identifier of the VPC endpoint in our account.

This also appears in the long-form DNS name which can be used to hit the
endpoint once it has been created

To enable SSL traffic over the VPC endpoint, the DNS common name must match the
SSL certificate on the target endpoint. In order to make this work, we create a
private Route53 override matching the domain of the target certificate, and point
it to the long-form DNS name fo the VPC endpoint.

Inputs
------

Required

+ `vpc_id` - VPC ID to create the VPC endpoint in
+ `vpc_endpoint_service` - Identifier of VPC endpoint
+ `ssl_domain_name` - Domain name created in a private R53 zone. This should match the SSL certificate on the VPC endpoint
+ `subnet_ids` - Subnet IDs
+ `security_group_ids` - Security group IDs

## Additional Info

There is additional documentation on VPC endpoints here:
https://git.xarth.tv/chat/terraform#consuming-an-endpoint-service-privatelink
