// In order to use SSL over a VPC Endpoint, we need to create a DNS override.
// This gives us a DNS name which matches the server's certificate name,
// instead of using the long AWS-provided DNS name which doesn't match the
// certificate.
// https://wiki.twitch.com/pages/viewpage.action?pageId=202703589

resource "aws_route53_zone" "override_zone" {
  name = var.ssl_domain_name

  vpc {
    vpc_id = var.vpc_id
  }
}

resource "aws_route53_record" "override_record" {
  zone_id = aws_route53_zone.override_zone.zone_id
  name    = var.ssl_domain_name
  type    = "A"

  alias {
    # Take the first entry because there is only one that is non-AZ specific
    name                   = aws_vpc_endpoint.endpoint.dns_entry[0]["dns_name"]
    zone_id                = aws_vpc_endpoint.endpoint.dns_entry[0]["hosted_zone_id"]
    evaluate_target_health = false
  }
}
