variable "aws_profile" {
  type    = string
  default = "twitch-cb-aws"
}

variable "aws_region" {
  type    = string
  default = "us-west-2"
}

variable "vpc_id" {
  type        = string
  description = "The VPC ID the endpoint service will live in."
}

variable "vpc_endpoint_service" {
  type        = string
  description = "The VPC endpoint service that this VPC endpoint will connect to."
}

variable "ssl_domain_name" {
  type        = string
  description = "The domain name matching the SSL certificate of the target service."
}

variable "subnet_ids" {
  type        = list(string)
  description = "A list of subnet IDs to create the network interfaces in."
}

variable "security_group_ids" {
  type        = list(string)
  description = "A list of security groups to associate with the network interfaces."
}
