terraform {
  required_version = ">= 0.12.24"

  backend "s3" {
    bucket  = "cb-roster-terraform"
    key     = "production/glue-qa/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

locals {
  environment          = "production"
  vpc_id               = "vpc-7851b71e"
  subnet_ids           = ["subnet-6f4a7808","subnet-45e7ad0c","subnet-86fe23dd"]
  security_group_ids   = ["sg-57251d2c"]
}

module "glue-qa" {
  source = "../../modules/glue-qa"

  environment          = local.environment
  db_subnet_group_name = "cb-roster-${local.environment}"
  db_identifier        = "cb-roster-${local.environment}"

  s3_output_kms_key_arn = "arn:aws:kms:us-west-2:989470033077:key/ed31fe31-8089-4e8d-9627-9f962561ca82"
  ssm_kms_key_id        = "arn:aws:kms:us-west-2:989470033077:key/7da1691b-2a74-4bda-93a9-aa087a80671f"
}
