terraform {
  required_version = ">= 0.12"

  backend "s3" {
    bucket  = "cb-roster-terraform"
    key     = "staging/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-cb-aws"
    encrypt = true
  }
}

locals {
  environment        = "staging"
  vpc_id             = "vpc-7851b71e"
  subnet_ids         = ["subnet-6f4a7808", "subnet-45e7ad0c", "subnet-86fe23dd"]
  security_group_ids = ["sg-57251d2c"]
}

module "app" {
  source                           = "../modules/app"
  environment                      = local.environment
  instance_type                    = "c4.large"
  asg_max_size                     = 10
  asg_min_size                     = 2
  deployment_batch_size_percentage = 50

  hard_delete_user_arn    = "arn:aws:sns:us-west-2:465369119046:notification-user-destroyed"
  sandstorm_iam_role_arn  = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/cb-roster-staging"
  s3_assets_iam_role_arn  = module.s3.assets_arn
  s3_uploads_iam_role_arn = module.s3.uploads_arn
  pdms_role_arn           = "arn:aws:iam::895799599216:role/PDMSLambda-CallerRole-18451FI19HSXT"
  pdms_lambda_arn         = "arn:aws:lambda:us-west-2:895799599216:function:PDMSLambda-LambdaFunction-IT8I1PE1YR81:live"
}

module "rds" {
  source = "../modules/rds"

  environment = local.environment
}

module "redis" {
  source = "../modules/redis"

  environment = local.environment
}

module "s3" {
  source = "../modules/s3"

  environment = local.environment

  uploads_bucket_name = "twitch-team-asset-upload-staging"
}

module "staging-liveline-vpc-endpoint-v2" {
  source = "../modules/vpc_endpoint"

  vpc_id               = local.vpc_id
  vpc_endpoint_service = "com.amazonaws.vpce.us-west-2.vpce-svc-0e4e8f90d47bca00d"
  ssl_domain_name      = "main.staging.liveline.twitch.a2z.com"
  subnet_ids           = local.subnet_ids
  security_group_ids   = local.security_group_ids
}

module "staging-receiver-vpc-endpoint" {
  source = "../modules/vpc_endpoint"

  vpc_id               = local.vpc_id
  vpc_endpoint_service = "com.amazonaws.vpce.us-west-2.vpce-svc-0796a8b920e1d6946"
  ssl_domain_name      = "staging.receiver.twitch.a2z.com"
  subnet_ids           = local.subnet_ids
  security_group_ids   = local.security_group_ids
}
