package interfaces

import (
	"net/http"
)

// Handler is just for mocks.
type Handler interface {
	http.Handler
}

// RoundTripper is just for mocks.
type RoundTripper interface {
	http.RoundTripper
}

// HTTPClient the commonly used HTTPClient interface we are using.
type HTTPClient interface {
	Do(*http.Request) (*http.Response, error)
}

// LambdaTransport is implemented by the aws lambda transport
type LambdaTransport interface {
	HTTPClient
	LambdaName() string
}
