package token

import (
	"context"
)

func NewOptions() *Options { return &Options{} }

type Options struct {
	scope Scope
	host  string
}

// WithHost returns a Options object with an audience host.
func (o *Options) WithHost(host string) *Options {
	o.host = host
	return o
}

// WithScope returns a Options object with a requesting scope.
func (o *Options) WithScope(s Scope) *Options {
	o.scope = s
	return o
}

// Scope returns the scope
func (o Options) Scope() Scope {
	return o.scope
}

// Host returns the host
func (o Options) Host() string {
	return o.host
}

//  Tokens returns tokens
type Tokens interface {
	Token(ctx context.Context, options *Options) (*Token, error)
}
