// Code generated by protoc-gen-twirp v5.5.0, DO NOT EDIT.
// source: liveline.proto

/*
Package liveline is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.5.0.

It is generated from these files:
	liveline.proto
*/
package liveline

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================
// Liveline Interface
// ==================

type Liveline interface {
	// GetStreamsByChannelIDs returns live streams that have input channel IDs
	// The streams are sorted by input order.
	// SLO@100ms
	GetStreamsByChannelIDs(context.Context, *StreamsByChannelIDsRequest) (*StreamsResponse, error)

	// GetStreamsByChannelNames returns live streams that have input channel names
	// The streams are sorted by input order.
	// SLO@150ms
	GetStreamsByChannelNames(context.Context, *StreamsByChannelNamesRequest) (*StreamsResponse, error)

	// GetStreamsByBroadcastIDs returns live streams that have input broadcast IDs
	// The streams are sorted by input order.
	// SLO@150ms
	GetStreamsByBroadcastIDs(context.Context, *StreamsByBroadcastIDsRequest) (*StreamsResponse, error)

	// GetFilteredStreamsByChannelIDs returns live streams that have input channel IDs
	// and meet the filter criterion.
	// The streams are sorted by input order by default.
	// SLO@200ms
	GetFilteredStreamsByChannelIDs(context.Context, *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error)

	// GetFilteredStreams returns live streams that meet the input filter criterion.
	// The streams are NOT sorted by default.
	// SLO@250ms
	GetFilteredStreams(context.Context, *FilteredStreamsRequest) (*StreamsResponse, error)

	// GetFilteredStreamsLarge returns live streams that meet the input filter criterion.
	// The streams are NOT sorted by default.
	// SLO@2000ms
	// This is same as GetFilteredStreams, but with larger page_size and higher SLO
	GetFilteredStreamsLarge(context.Context, *FilteredStreamsRequest) (*StreamsResponse, error)

	// GetStreamSummary aggregates the streams by provided input metadata field
	// and meet StreamSummaryFilter requirements
	// The response includes the total number of viewers and total number of channels for that field
	// The streams are sorted by popularity (CCU) by default.
	// SLO@200ms
	GetStreamSummary(context.Context, *StreamSummaryRequest) (*StreamSummaryResponse, error)
}

// ========================
// Liveline Protobuf Client
// ========================

type livelineProtobufClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLivelineProtobufClient creates a Protobuf client that implements the Liveline interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewLivelineProtobufClient(addr string, client HTTPClient) Liveline {
	prefix := urlBase(addr) + LivelinePathPrefix
	urls := [7]string{
		prefix + "GetStreamsByChannelIDs",
		prefix + "GetStreamsByChannelNames",
		prefix + "GetStreamsByBroadcastIDs",
		prefix + "GetFilteredStreamsByChannelIDs",
		prefix + "GetFilteredStreams",
		prefix + "GetFilteredStreamsLarge",
		prefix + "GetStreamSummary",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &livelineProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &livelineProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *livelineProtobufClient) GetStreamsByChannelIDs(ctx context.Context, in *StreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamsByChannelNames(ctx context.Context, in *StreamsByChannelNamesRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamsByBroadcastIDs(ctx context.Context, in *StreamsByBroadcastIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreamsByChannelIDs(ctx context.Context, in *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreams(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetFilteredStreamsLarge(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	out := new(StreamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineProtobufClient) GetStreamSummary(ctx context.Context, in *StreamSummaryRequest) (*StreamSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	out := new(StreamSummaryResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ====================
// Liveline JSON Client
// ====================

type livelineJSONClient struct {
	client HTTPClient
	urls   [7]string
}

// NewLivelineJSONClient creates a JSON client that implements the Liveline interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewLivelineJSONClient(addr string, client HTTPClient) Liveline {
	prefix := urlBase(addr) + LivelinePathPrefix
	urls := [7]string{
		prefix + "GetStreamsByChannelIDs",
		prefix + "GetStreamsByChannelNames",
		prefix + "GetStreamsByBroadcastIDs",
		prefix + "GetFilteredStreamsByChannelIDs",
		prefix + "GetFilteredStreams",
		prefix + "GetFilteredStreamsLarge",
		prefix + "GetStreamSummary",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &livelineJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &livelineJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *livelineJSONClient) GetStreamsByChannelIDs(ctx context.Context, in *StreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamsByChannelNames(ctx context.Context, in *StreamsByChannelNamesRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamsByBroadcastIDs(ctx context.Context, in *StreamsByBroadcastIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreamsByChannelIDs(ctx context.Context, in *FilteredStreamsByChannelIDsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreams(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetFilteredStreamsLarge(ctx context.Context, in *FilteredStreamsRequest) (*StreamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	out := new(StreamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *livelineJSONClient) GetStreamSummary(ctx context.Context, in *StreamSummaryRequest) (*StreamSummaryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	out := new(StreamSummaryResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// =======================
// Liveline Server Handler
// =======================

type livelineServer struct {
	Liveline
	hooks *twirp.ServerHooks
}

func NewLivelineServer(svc Liveline, hooks *twirp.ServerHooks) TwirpServer {
	return &livelineServer{
		Liveline: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *livelineServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// LivelinePathPrefix is used for all URL paths on a twirp Liveline server.
// Requests are always: POST LivelinePathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const LivelinePathPrefix = "/twirp/liveline.Liveline/"

func (s *livelineServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "liveline")
	ctx = ctxsetters.WithServiceName(ctx, "Liveline")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/liveline.Liveline/GetStreamsByChannelIDs":
		s.serveGetStreamsByChannelIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamsByChannelNames":
		s.serveGetStreamsByChannelNames(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamsByBroadcastIDs":
		s.serveGetStreamsByBroadcastIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreamsByChannelIDs":
		s.serveGetFilteredStreamsByChannelIDs(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreams":
		s.serveGetFilteredStreams(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetFilteredStreamsLarge":
		s.serveGetFilteredStreamsLarge(ctx, resp, req)
		return
	case "/twirp/liveline.Liveline/GetStreamSummary":
		s.serveGetStreamSummary(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *livelineServer) serveGetStreamsByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelNames(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByChannelNamesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByChannelNamesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByChannelNamesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByChannelNamesRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByChannelNamesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByChannelNames")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByChannelNamesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByChannelNames(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByChannelNames. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByBroadcastIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamsByBroadcastIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamsByBroadcastIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamsByBroadcastIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamsByBroadcastIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamsByBroadcastIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamsByBroadcastIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamsByBroadcastIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamsByBroadcastIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetStreamsByBroadcastIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsByChannelIDsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsByChannelIDsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsByChannelIDsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsByChannelIDsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsByChannelIDs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsByChannelIDsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsByChannelIDs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsByChannelIDs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsLarge(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetFilteredStreamsLargeJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetFilteredStreamsLargeProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetFilteredStreamsLargeJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(FilteredStreamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsLarge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsLarge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetFilteredStreamsLargeProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetFilteredStreamsLarge")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(FilteredStreamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetFilteredStreamsLarge(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamsResponse and nil error while calling GetFilteredStreamsLarge. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamSummary(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamSummaryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamSummaryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *livelineServer) serveGetStreamSummaryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(StreamSummaryRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamSummaryResponse and nil error while calling GetStreamSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) serveGetStreamSummaryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamSummary")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(StreamSummaryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StreamSummaryResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Liveline.GetStreamSummary(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StreamSummaryResponse and nil error while calling GetStreamSummary. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *livelineServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *livelineServer) ProtocGenTwirpVersion() string {
	return "v5.5.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.5.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2609 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x5f, 0x6f, 0x23, 0x49,
	0xb5, 0xbf, 0xb6, 0xe3, 0xc4, 0x3e, 0x8e, 0x93, 0x4e, 0x4d, 0x26, 0x93, 0xc9, 0xec, 0xec, 0x64,
	0x33, 0xab, 0xd5, 0x6c, 0xb4, 0xca, 0xdc, 0x9b, 0xbd, 0x7b, 0x75, 0x57, 0x20, 0x90, 0x63, 0x77,
	0x1c, 0x6b, 0x9d, 0x38, 0x94, 0x3d, 0xb3, 0x0c, 0x12, 0x6a, 0x55, 0xba, 0x2b, 0xed, 0x66, 0x6c,
	0x77, 0xd3, 0x5d, 0xce, 0xac, 0xf7, 0x0d, 0x24, 0xc4, 0x0b, 0x42, 0x3c, 0xf2, 0x02, 0xbc, 0xf0,
	0x82, 0x78, 0xda, 0x17, 0x9e, 0xf9, 0x00, 0x48, 0x7c, 0x00, 0x24, 0x3e, 0x03, 0x1f, 0x01, 0xd5,
	0xbf, 0xee, 0x72, 0xc7, 0x93, 0x21, 0x8a, 0xe0, 0xcd, 0x7d, 0xce, 0xef, 0x9c, 0x3a, 0xff, 0xea,
	0xd4, 0xa9, 0x32, 0xac, 0x8d, 0x82, 0x2b, 0x3a, 0x0a, 0x26, 0xf4, 0x20, 0x8a, 0x43, 0x16, 0xa2,
	0x8a, 0xfe, 0xde, 0x79, 0xe2, 0x87, 0xa1, 0x3f, 0xa2, 0xcf, 0x05, 0xfd, 0x62, 0x7a, 0xf9, 0x9c,
	0x05, 0x63, 0x9a, 0x30, 0x32, 0x8e, 0x24, 0x74, 0xef, 0xd7, 0x05, 0xd8, 0xe9, 0xb3, 0x98, 0x92,
	0x71, 0x72, 0x34, 0x6b, 0x0e, 0xc9, 0x64, 0x42, 0x47, 0x9d, 0x56, 0x82, 0xe9, 0x8f, 0xa7, 0x34,
	0x61, 0xe8, 0x09, 0xd4, 0x5c, 0x49, 0x74, 0x02, 0x2f, 0xd9, 0x2e, 0xec, 0x96, 0x9e, 0x55, 0x31,
	0x28, 0x52, 0xc7, 0x4b, 0xd0, 0x01, 0x54, 0x92, 0x30, 0x66, 0xce, 0x6b, 0x3a, 0xdb, 0x2e, 0xee,
	0x16, 0x9e, 0xad, 0x1d, 0xde, 0x3b, 0x48, 0xad, 0xe9, 0x87, 0x31, 0x3b, 0x0e, 0xe8, 0xc8, 0xc3,
	0x2b, 0x1c, 0xf4, 0x05, 0x9d, 0xa1, 0x8f, 0xa1, 0x1c, 0xc6, 0x1e, 0x8d, 0xb7, 0x4b, 0x8b, 0xc0,
	0x3d, 0xce, 0xc2, 0x12, 0xb1, 0xf7, 0xdb, 0x02, 0xbc, 0x97, 0x37, 0xed, 0x8c, 0x8c, 0x69, 0x6a,
	0xdc, 0x53, 0xa8, 0x6b, 0xe3, 0x26, 0x9c, 0xae, 0xcc, 0x5b, 0x75, 0x0d, 0xec, 0x7f, 0xcc, 0xc0,
	0xa3, 0x38, 0x24, 0x9e, 0x4b, 0x12, 0x66, 0x44, 0xef, 0x29, 0xd4, 0x2f, 0x34, 0xd9, 0x88, 0xdf,
	0x6a, 0x4a, 0xfc, 0x37, 0x47, 0xf0, 0xcf, 0x05, 0xd8, 0x94, 0x06, 0xf6, 0xa7, 0xe3, 0x31, 0x89,
	0x67, 0xda, 0xb0, 0xcf, 0x60, 0xe5, 0x32, 0x18, 0x31, 0x1a, 0x4b, 0x93, 0x6a, 0x87, 0x8f, 0x32,
	0x2d, 0x0d, 0xdf, 0x8f, 0xa9, 0x4f, 0x58, 0x10, 0x4e, 0x8e, 0x05, 0x06, 0x6b, 0x2c, 0xfa, 0x0c,
	0x2a, 0x7e, 0x1c, 0x4e, 0x23, 0xe7, 0x42, 0x9b, 0xba, 0xf3, 0x16, 0x39, 0x61, 0xb1, 0xc0, 0x1e,
	0xcd, 0xd0, 0x63, 0x80, 0x88, 0xf8, 0xd4, 0x61, 0xe1, 0x6b, 0x3a, 0x11, 0x66, 0x57, 0x71, 0x95,
	0x53, 0x06, 0x9c, 0x80, 0x1e, 0x81, 0xf8, 0x70, 0x92, 0xe0, 0x6b, 0xba, 0xbd, 0xb4, 0x5b, 0x78,
	0x56, 0xc2, 0x15, 0x4e, 0xe8, 0x07, 0x5f, 0xd3, 0xbd, 0x19, 0x6c, 0x5c, 0x33, 0x08, 0x7d, 0x17,
	0x40, 0x9a, 0x24, 0x82, 0x56, 0x10, 0x96, 0xec, 0xde, 0xe0, 0x81, 0xb4, 0xa7, 0x2a, 0x65, 0x78,
	0x0c, 0x9f, 0x42, 0x5d, 0x29, 0xb8, 0x22, 0xa3, 0x29, 0x4d, 0xb6, 0x8b, 0x32, 0x31, 0x92, 0xf8,
	0x52, 0xd0, 0xf6, 0x1c, 0x58, 0x56, 0xeb, 0x1d, 0x2e, 0x58, 0xcf, 0x88, 0xfb, 0xb1, 0xd6, 0x6b,
	0x2e, 0xf1, 0x01, 0xac, 0x9a, 0x4b, 0xa8, 0x15, 0x6a, 0xc6, 0x0a, 0x7b, 0x7f, 0x29, 0xc0, 0x9e,
	0x94, 0xa5, 0xde, 0x5d, 0xf6, 0xe0, 0x7e, 0x96, 0xcd, 0xa2, 0xc8, 0xa6, 0x95, 0xb7, 0x2d, 0x4b,
	0xa1, 0x59, 0x6d, 0xa5, 0xdb, 0x54, 0xdb, 0xd2, 0x3b, 0xab, 0xed, 0x6f, 0x05, 0xd8, 0xca, 0xb9,
	0xa3, 0x5d, 0xd8, 0xcf, 0xd7, 0xdb, 0x0d, 0x16, 0xce, 0x95, 0x43, 0x71, 0xbe, 0x1c, 0xde, 0x55,
	0x4a, 0xa6, 0x77, 0x4b, 0xb7, 0xf1, 0xae, 0xfc, 0x4e, 0xef, 0x3c, 0x58, 0x4f, 0x9d, 0x4a, 0xa2,
	0x70, 0x92, 0x50, 0x74, 0x08, 0x2b, 0x89, 0x24, 0x29, 0xaf, 0xb6, 0x0d, 0x79, 0xc1, 0xd0, 0x50,
	0xac, 0x81, 0x39, 0x07, 0x8a, 0x39, 0x07, 0xf6, 0x7e, 0xb3, 0x0c, 0x6b, 0xf3, 0xa2, 0x5c, 0x22,
	0x4b, 0xbf, 0x28, 0xbe, 0x2a, 0xae, 0xa6, 0xd9, 0xe7, 0x75, 0x66, 0x36, 0x41, 0xa5, 0xb2, 0x66,
	0xf4, 0x40, 0x0e, 0x31, 0xdb, 0x90, 0x08, 0x5b, 0x09, 0xd7, 0x8c, 0x2e, 0x84, 0xbe, 0x05, 0x75,
	0x3f, 0x26, 0x97, 0x97, 0x01, 0x0b, 0x1c, 0x8f, 0x30, 0x22, 0xa2, 0x57, 0x3b, 0xdc, 0xca, 0x1c,
	0x6a, 0x2b, 0x76, 0x8b, 0x30, 0x82, 0x57, 0x7d, 0xe3, 0x0b, 0xfd, 0x7f, 0x66, 0x82, 0x90, 0x2d,
	0x0b, 0xd9, 0xfb, 0x99, 0xac, 0xaa, 0x69, 0x21, 0xaa, 0x2d, 0x13, 0x92, 0x87, 0x00, 0xd3, 0x64,
	0x48, 0x63, 0x29, 0xb7, 0x2c, 0xe4, 0x8c, 0x24, 0xbc, 0xe0, 0x3c, 0x21, 0x55, 0x9d, 0xea, 0x9f,
	0xc2, 0x54, 0x32, 0xa6, 0xce, 0x98, 0x32, 0x22, 0xc4, 0x56, 0xae, 0x99, 0x4a, 0xc6, 0xf4, 0x54,
	0x71, 0xf1, 0xaa, 0x6f, 0x7c, 0xa1, 0x16, 0x58, 0x11, 0x89, 0xd9, 0x84, 0xc6, 0xc9, 0x30, 0x88,
	0xe4, 0xb2, 0x15, 0x21, 0xff, 0x30, 0x93, 0x3f, 0xcf, 0x10, 0x62, 0xf1, 0xf5, 0x68, 0x9e, 0x20,
	0xb4, 0x8c, 0xc8, 0x2c, 0x61, 0xa2, 0xc7, 0x48, 0x2d, 0xd5, 0x6b, 0x5a, 0x32, 0x84, 0xd2, 0x32,
	0x4f, 0x40, 0xdf, 0x81, 0xb5, 0xab, 0x80, 0xbe, 0x71, 0xc3, 0xe9, 0x84, 0x49, 0x1d, 0x20, 0x74,
	0x3c, 0xc8, 0x74, 0xbc, 0xd4, 0x7c, 0xa1, 0xa1, 0x7e, 0x65, 0x7e, 0xa2, 0x2e, 0x6c, 0xa5, 0x39,
	0x73, 0x09, 0xa3, 0x7e, 0x18, 0xcf, 0xa4, 0x9e, 0xda, 0x8d, 0xc9, 0xdb, 0xd4, 0x52, 0x4d, 0x25,
	0x24, 0xb4, 0x3d, 0x87, 0xea, 0x34, 0xd1, 0x99, 0x58, 0x15, 0x0a, 0x90, 0x99, 0x09, 0x95, 0x88,
	0xca, 0x54, 0xfd, 0x42, 0x6d, 0xd8, 0x88, 0x69, 0xc2, 0xe2, 0xc0, 0xe5, 0x1e, 0x25, 0x52, 0xb0,
	0x2e, 0x04, 0x8d, 0x53, 0x01, 0x1b, 0x10, 0xa1, 0xc0, 0x8a, 0x73, 0x14, 0xb4, 0x0f, 0x1b, 0x72,
	0x77, 0x38, 0xc6, 0xce, 0x58, 0x13, 0x65, 0xbc, 0x2e, 0x19, 0xe7, 0xe9, 0xfe, 0x18, 0x42, 0x7d,
	0x2e, 0x26, 0xe8, 0x3d, 0xa8, 0xa6, 0x51, 0x11, 0x9b, 0xa3, 0x84, 0x33, 0x02, 0xfa, 0x1c, 0x60,
	0x1a, 0x79, 0x84, 0x51, 0xcf, 0x21, 0x4c, 0x6c, 0x0d, 0x6e, 0x9c, 0x9c, 0x89, 0x0e, 0xf4, 0x4c,
	0x74, 0x30, 0xd0, 0x33, 0x11, 0xae, 0x2a, 0x74, 0x83, 0xed, 0xfd, 0xa9, 0x00, 0xab, 0x66, 0xd8,
	0xd0, 0xc7, 0xb0, 0xc4, 0x88, 0xaf, 0xb7, 0xfa, 0xfd, 0xeb, 0xc1, 0x1d, 0x10, 0x1f, 0x0b, 0x88,
	0xd8, 0xb2, 0xe1, 0x84, 0xd1, 0x89, 0xd8, 0x6e, 0x6a, 0x93, 0x2b, 0x8a, 0xda, 0xb2, 0x8a, 0xcd,
	0x66, 0x11, 0xd5, 0xfb, 0x51, 0xd1, 0x06, 0xb3, 0x88, 0xe6, 0x0c, 0x5f, 0xba, 0x8d, 0xe1, 0x5f,
	0x43, 0xcd, 0xb0, 0x08, 0xdd, 0x87, 0x65, 0x46, 0xfc, 0xac, 0x75, 0x94, 0x19, 0xf1, 0x3b, 0x1e,
	0x7a, 0x08, 0x15, 0x4e, 0x36, 0x5a, 0xc6, 0x0a, 0x23, 0xbe, 0x68, 0x17, 0x77, 0x58, 0xfb, 0x77,
	0x45, 0xa8, 0x19, 0x9b, 0x5d, 0x1c, 0x5d, 0xba, 0x32, 0x95, 0x05, 0x65, 0x0c, 0x9a, 0xd4, 0xf1,
	0xc4, 0x08, 0xa7, 0x01, 0x86, 0x2d, 0xab, 0x9a, 0x28, 0x0c, 0xfa, 0x18, 0x2c, 0x2f, 0x88, 0xa9,
	0xcb, 0x38, 0x6a, 0x18, 0x78, 0x9e, 0x6a, 0xfd, 0x15, 0xbc, 0x9e, 0xd2, 0x4f, 0x04, 0x99, 0x1f,
	0x1e, 0x41, 0xe2, 0x8c, 0x09, 0x9b, 0xc6, 0x72, 0x96, 0xa8, 0xe0, 0x4a, 0x90, 0x9c, 0x8a, 0x6f,
	0xf4, 0x3f, 0xb0, 0x99, 0xf6, 0x3c, 0x1a, 0x3b, 0x23, 0x32, 0xf1, 0xa7, 0xc4, 0xa7, 0xa2, 0x5f,
	0x55, 0xf1, 0x3d, 0x83, 0xd7, 0x55, 0x2c, 0xb4, 0x09, 0x65, 0x16, 0xb0, 0x11, 0x15, 0xbd, 0x89,
	0x07, 0x8f, 0x7f, 0xe4, 0x22, 0xb4, 0x72, 0x9b, 0x08, 0xfd, 0xa3, 0x04, 0xd5, 0xb4, 0xad, 0xa1,
	0x07, 0xb0, 0x32, 0x8d, 0x1c, 0x3e, 0x93, 0xab, 0xd8, 0x2c, 0x4f, 0x23, 0x2e, 0x96, 0x37, 0x35,
	0x09, 0x2f, 0xd9, 0x1b, 0x12, 0xeb, 0xf0, 0x98, 0xa6, 0xf6, 0x15, 0x0b, 0x59, 0x50, 0x1a, 0x8e,
	0x12, 0x11, 0x98, 0x32, 0xe6, 0x3f, 0x79, 0xf4, 0xc9, 0x95, 0xeb, 0x44, 0x71, 0x78, 0x19, 0x8c,
	0x64, 0x38, 0xaa, 0x18, 0xc8, 0x95, 0x7b, 0x2e, 0x29, 0x3c, 0x5a, 0x1c, 0x30, 0xa2, 0x57, 0x74,
	0xa4, 0xa2, 0x50, 0x21, 0x57, 0x6e, 0x97, 0x7f, 0xf3, 0x2a, 0xbd, 0x0a, 0x3c, 0x1a, 0x3a, 0x43,
	0x1a, 0xf8, 0x43, 0x26, 0x22, 0x50, 0xc6, 0x35, 0x41, 0x3b, 0x11, 0x24, 0xbe, 0x80, 0x84, 0xbc,
	0x09, 0x3c, 0x36, 0x14, 0x81, 0x28, 0x63, 0x10, 0xa4, 0x2f, 0x39, 0x25, 0x03, 0xb8, 0xa1, 0x47,
	0x5d, 0xd1, 0x69, 0xab, 0x0a, 0xd0, 0xe4, 0x14, 0x9e, 0x7f, 0x09, 0xb8, 0x08, 0x58, 0x4c, 0x18,
	0x15, 0x6d, 0xb4, 0x8c, 0xe5, 0xca, 0x47, 0x92, 0xc6, 0x3d, 0xbb, 0x8c, 0x12, 0xd1, 0x1d, 0xcb,
	0x98, 0xff, 0xe4, 0xbb, 0x9e, 0x4e, 0xdc, 0x78, 0x16, 0x31, 0xea, 0x89, 0x6e, 0x57, 0xc6, 0x19,
	0x21, 0x1f, 0xbc, 0x68, 0x44, 0xd8, 0x65, 0x18, 0x8f, 0x45, 0x57, 0x9b, 0x0f, 0xde, 0xb9, 0x62,
	0xe5, 0x32, 0x5a, 0xbf, 0x45, 0x46, 0xb9, 0x8f, 0xaa, 0x7d, 0x89, 0xcd, 0x2c, 0x1b, 0x17, 0x48,
	0x12, 0xdf, 0xcb, 0x7b, 0xbf, 0x2f, 0xc2, 0xaa, 0x79, 0x24, 0xf1, 0x56, 0xeb, 0x26, 0x7e, 0x28,
	0x3b, 0x66, 0x21, 0xdf, 0x6a, 0x9b, 0xfd, 0x76, 0x4f, 0xb6, 0x5a, 0x0e, 0x12, 0x65, 0xf2, 0x09,
	0x54, 0x46, 0xa1, 0x3a, 0x5c, 0x65, 0x13, 0xdb, 0xc8, 0xf0, 0xdd, 0x5e, 0x57, 0xc0, 0x57, 0x46,
	0xe1, 0x48, 0x77, 0xf2, 0x68, 0x7a, 0xe1, 0x4b, 0x78, 0x29, 0xaf, 0xfe, 0xfc, 0xc5, 0x51, 0x5b,
	0xaa, 0xe7, 0x20, 0x7d, 0x10, 0x85, 0x57, 0x34, 0x7e, 0x43, 0x98, 0x3b, 0x34, 0x4f, 0x7f, 0xe3,
	0x20, 0xea, 0x69, 0xbe, 0x3c, 0x88, 0x42, 0xf3, 0x93, 0x1f, 0x87, 0x43, 0x4a, 0x62, 0x36, 0x4c,
	0x58, 0x38, 0xa1, 0xe6, 0x0c, 0x60, 0x1c, 0x87, 0x27, 0x19, 0x42, 0x1e, 0x87, 0xc3, 0x79, 0xc2,
	0xde, 0x1f, 0x0b, 0x50, 0xd1, 0xbe, 0xf3, 0x94, 0x8f, 0x49, 0xa4, 0x5a, 0x16, 0xff, 0xc9, 0x1b,
	0xd6, 0x98, 0x44, 0x73, 0x0d, 0x6b, 0x4c, 0x22, 0xd1, 0x1f, 0x1e, 0x00, 0xff, 0xe9, 0x04, 0x63,
	0x5f, 0x4d, 0x84, 0xcb, 0x63, 0x12, 0x75, 0xc6, 0x3e, 0x7a, 0x1f, 0x20, 0x89, 0xa8, 0xcb, 0x08,
	0x0b, 0xe3, 0x44, 0x38, 0x55, 0xc6, 0x06, 0x25, 0x97, 0xf5, 0xf2, 0x6d, 0xf6, 0xf1, 0x4f, 0x8b,
	0xb0, 0xa2, 0x22, 0x2f, 0x2a, 0x60, 0x3a, 0x1e, 0x87, 0x13, 0x1a, 0x1b, 0x5d, 0x4e, 0x93, 0x3a,
	0x9e, 0x9a, 0xe0, 0xc7, 0x11, 0x1f, 0x16, 0xd4, 0x81, 0x50, 0x16, 0x13, 0xbc, 0x20, 0xc9, 0x13,
	0x21, 0x48, 0x1c, 0x37, 0x9c, 0x4c, 0xa8, 0xcb, 0x4b, 0x5a, 0x76, 0xb7, 0x5a, 0x90, 0x34, 0x35,
	0x89, 0xef, 0x94, 0x74, 0x91, 0x98, 0x4c, 0x5e, 0xab, 0xed, 0xbc, 0xaa, 0x89, 0x98, 0x4c, 0x5e,
	0xa3, 0x43, 0xb8, 0x3f, 0x07, 0x72, 0x26, 0xd3, 0x31, 0x8d, 0x03, 0x57, 0xf8, 0x56, 0xc6, 0xf7,
	0x4c, 0xf0, 0x99, 0x64, 0xe5, 0x82, 0xb0, 0x7c, 0x9b, 0x20, 0xfc, 0xaa, 0x00, 0x15, 0x5d, 0x4f,
	0xe8, 0x13, 0x40, 0x7c, 0xc2, 0xa1, 0xb1, 0x43, 0x78, 0xd2, 0x9d, 0xec, 0x48, 0x2e, 0x63, 0x4b,
	0x72, 0x1a, 0x9c, 0xd1, 0x14, 0x27, 0xf3, 0x23, 0xa8, 0xca, 0x29, 0x2e, 0xf4, 0x74, 0x3e, 0x2b,
	0x62, 0x52, 0x0b, 0xbd, 0x7c, 0x7f, 0x2d, 0xdd, 0xc6, 0xa4, 0x9f, 0x14, 0xa1, 0x3e, 0x57, 0xac,
	0xe8, 0x08, 0x1e, 0x9b, 0xdd, 0xc0, 0x1d, 0x92, 0x98, 0xb8, 0xfc, 0x17, 0xb9, 0x08, 0x46, 0x01,
	0x9b, 0xa9, 0x22, 0x7b, 0x64, 0x80, 0x9a, 0x1a, 0xd3, 0x90, 0x10, 0xf4, 0x6d, 0xd8, 0x59, 0xac,
	0x23, 0x0e, 0x47, 0xda, 0xfc, 0xed, 0x45, 0x0a, 0x70, 0x38, 0xa2, 0xe8, 0x53, 0xb8, 0xbf, 0x50,
	0x5a, 0x55, 0xeb, 0xe6, 0x22, 0xc1, 0xbb, 0x9c, 0xc2, 0xdf, 0x14, 0x61, 0x3d, 0xb7, 0xdd, 0x78,
	0x65, 0x98, 0x36, 0x0c, 0x69, 0x1c, 0xca, 0xbd, 0x54, 0xb8, 0xd6, 0x14, 0x4f, 0x68, 0x1c, 0x8a,
	0x7d, 0xf5, 0xbf, 0xb0, 0x75, 0x4d, 0xc6, 0x1d, 0x91, 0x24, 0x51, 0x1e, 0x6f, 0xe6, 0x84, 0x9a,
	0x9c, 0xc7, 0xeb, 0x20, 0x8c, 0xa2, 0x70, 0xc2, 0xc7, 0x9b, 0x6c, 0x19, 0xe9, 0xaa, 0xa5, 0x39,
	0xe9, 0x1a, 0x07, 0x70, 0x6f, 0x1e, 0x2d, 0x17, 0x90, 0xc5, 0xbd, 0x61, 0xc2, 0xa5, 0xf6, 0xb9,
	0xba, 0x29, 0xdf, 0x58, 0x37, 0xb7, 0x2a, 0xe5, 0x6f, 0x0a, 0xb0, 0x9e, 0x9b, 0xfb, 0xf9, 0x18,
	0x17, 0x24, 0x8e, 0x1a, 0xfe, 0x45, 0xa0, 0x2a, 0xb8, 0x1a, 0x24, 0x0a, 0xa6, 0x36, 0x2d, 0x9f,
	0xb4, 0x46, 0x01, 0x3f, 0xba, 0x8a, 0x7a, 0xd3, 0x36, 0x34, 0x49, 0x41, 0x3c, 0x7e, 0x9e, 0x86,
	0x91, 0x4a, 0xb8, 0x80, 0xb4, 0x34, 0xe9, 0x2e, 0x79, 0xfe, 0x79, 0x09, 0xd6, 0x73, 0xb7, 0x0c,
	0xbe, 0x62, 0xe2, 0xd2, 0xec, 0xcc, 0x93, 0xe9, 0xad, 0x25, 0x2e, 0x4d, 0xcf, 0xba, 0x03, 0xb8,
	0xc7, 0x21, 0x62, 0x94, 0x71, 0x08, 0x63, 0x71, 0x70, 0x31, 0x65, 0xba, 0x8a, 0x37, 0x12, 0x97,
	0x0e, 0x38, 0xa7, 0xa1, 0x19, 0xe8, 0x23, 0x58, 0xcf, 0xf0, 0x3e, 0x9d, 0xc4, 0x3a, 0x9b, 0x75,
	0x8d, 0x6d, 0x73, 0x22, 0xda, 0x95, 0x4b, 0x4b, 0x5c, 0xe0, 0xe9, 0x79, 0x43, 0x83, 0x3a, 0x1e,
	0x2f, 0x8d, 0x0c, 0x91, 0x1b, 0xbf, 0x2c, 0x8d, 0x4b, 0x67, 0xaf, 0x0f, 0x61, 0x2d, 0x43, 0x8b,
	0x22, 0x5a, 0x56, 0x2d, 0x4f, 0x21, 0x17, 0x4c, 0xab, 0xb7, 0x99, 0xc5, 0xd0, 0x09, 0x7c, 0x90,
	0x2d, 0x10, 0xc5, 0x34, 0xa1, 0xcc, 0x61, 0xf4, 0x2b, 0xe6, 0x78, 0x34, 0x71, 0xe3, 0x20, 0xe2,
	0x41, 0x55, 0x33, 0xcb, 0x63, 0xbd, 0xe6, 0xb9, 0x80, 0x0d, 0xe8, 0x57, 0xac, 0x95, 0x81, 0xf6,
	0xfe, 0x5e, 0x80, 0x8a, 0xbe, 0x22, 0xf1, 0x14, 0x88, 0x9b, 0x94, 0xba, 0xe8, 0xea, 0x14, 0x70,
	0x9a, 0x9a, 0x8d, 0xf9, 0x95, 0x47, 0x5e, 0xb6, 0x82, 0x84, 0x77, 0x46, 0xf3, 0x54, 0x5b, 0x17,
	0x17, 0x2c, 0x49, 0x17, 0x0e, 0x3e, 0x85, 0xba, 0x54, 0xa7, 0x46, 0x62, 0x15, 0x7c, 0xb1, 0x86,
	0xbe, 0xc1, 0xa5, 0xa0, 0x34, 0xa8, 0x4b, 0x19, 0x28, 0x0d, 0xe8, 0x1d, 0x8e, 0xbb, 0x10, 0xac,
	0xfc, 0x4d, 0x0e, 0xed, 0x42, 0xcd, 0xb8, 0xcb, 0x69, 0x37, 0x0d, 0xd2, 0x5d, 0xae, 0x5f, 0x3f,
	0x2b, 0xc0, 0xfd, 0xdc, 0xd3, 0xa5, 0x7a, 0x0f, 0x39, 0x85, 0x4d, 0x35, 0x6f, 0x25, 0x92, 0xe3,
	0x04, 0x8c, 0x8e, 0x17, 0x3c, 0x64, 0xce, 0x89, 0x77, 0x18, 0x1d, 0x63, 0x94, 0xe4, 0x49, 0xef,
	0x7c, 0x90, 0xf9, 0x43, 0x01, 0x36, 0xae, 0x29, 0x42, 0x3b, 0x50, 0x51, 0xd9, 0x4d, 0xd4, 0x09,
	0x97, 0x7e, 0xcf, 0xdf, 0x48, 0x8b, 0xf9, 0x1b, 0xe9, 0x13, 0xa8, 0xc9, 0x27, 0x54, 0xf9, 0x2a,
	0x28, 0x73, 0x09, 0x82, 0x24, 0x1e, 0x05, 0xd1, 0xe7, 0xf0, 0x30, 0xe7, 0x9e, 0x61, 0x9e, 0xcc,
	0xea, 0xd6, 0x9c, 0x1b, 0xe9, 0xe5, 0x78, 0xff, 0xff, 0xa0, 0x9a, 0xbe, 0x71, 0xa1, 0x7b, 0xb0,
	0xde, 0xef, 0xe1, 0xc1, 0x71, 0xc7, 0xee, 0xb6, 0x9c, 0x17, 0x67, 0x7d, 0x7b, 0x60, 0xfd, 0x17,
	0x5a, 0x81, 0x52, 0xb3, 0xf9, 0xd2, 0x2a, 0xa0, 0x1a, 0xac, 0x60, 0xbb, 0x69, 0x9f, 0x35, 0x5f,
	0x59, 0xc5, 0xfd, 0x4f, 0xa5, 0x9c, 0x78, 0xee, 0xd2, 0x72, 0x3d, 0xdc, 0xb2, 0x71, 0x2a, 0x57,
	0x81, 0xa5, 0x96, 0xdd, 0x6f, 0x5a, 0x05, 0xae, 0xa1, 0xd1, 0x6f, 0x5a, 0xc5, 0xfd, 0x5f, 0x94,
	0xa0, 0x9a, 0x3e, 0x7c, 0x72, 0xa9, 0xe3, 0x4e, 0x77, 0x60, 0xe3, 0x2f, 0xec, 0x57, 0xa9, 0xd4,
	0x3a, 0xd4, 0x9a, 0x8d, 0x81, 0xdd, 0xee, 0xe1, 0x57, 0x4e, 0xa7, 0x65, 0x15, 0xd0, 0x06, 0xd4,
	0x53, 0xc2, 0x59, 0xe3, 0xd4, 0xb6, 0x8a, 0x1c, 0x33, 0x68, 0xb4, 0x9d, 0x4e, 0xab, 0xef, 0x34,
	0xce, 0x5a, 0x56, 0x89, 0x63, 0x38, 0x81, 0xb3, 0x25, 0x69, 0x09, 0x6d, 0xc3, 0xe6, 0x11, 0xee,
	0x35, 0x5a, 0xcd, 0x46, 0x7f, 0x60, 0x63, 0xa7, 0xdf, 0x3b, 0x1e, 0x7c, 0xd9, 0xc0, 0xb6, 0x55,
	0xce, 0x73, 0xce, 0xbb, 0x8d, 0xc1, 0x71, 0x0f, 0x9f, 0x5a, 0xcb, 0x79, 0x4e, 0xb7, 0x71, 0xd6,
	0x7e, 0xd1, 0x68, 0xdb, 0xd6, 0x0a, 0x5f, 0xf1, 0x45, 0xdf, 0xc6, 0x0e, 0xb6, 0xdb, 0x9d, 0xde,
	0x99, 0x55, 0xe1, 0x84, 0xfe, 0x00, 0xdb, 0x8d, 0x53, 0x67, 0xf0, 0xea, 0xdc, 0xb6, 0xaa, 0xdc,
	0xc7, 0x93, 0x6e, 0xdf, 0x02, 0xce, 0x69, 0xbc, 0x6c, 0x3a, 0xe7, 0xb8, 0x77, 0xdc, 0xe9, 0xda,
	0x56, 0x8d, 0xbb, 0x79, 0xda, 0xf8, 0xbe, 0x63, 0x12, 0x57, 0xb9, 0xc5, 0x9a, 0xd8, 0xb5, 0x5f,
	0xda, 0x5d, 0xab, 0x8e, 0xd6, 0x00, 0x38, 0xe9, 0xc4, 0xee, 0xb4, 0x4f, 0x06, 0xd6, 0x1a, 0xda,
	0x04, 0x0b, 0xdb, 0xfd, 0x01, 0xee, 0x34, 0x07, 0x9d, 0xde, 0x99, 0x5c, 0x67, 0x9d, 0x53, 0x5b,
	0x1d, 0x6c, 0x37, 0x07, 0x3c, 0x1e, 0x27, 0x9d, 0x56, 0xcb, 0x3e, 0xb3, 0x2c, 0x6e, 0x79, 0x1a,
	0x24, 0x33, 0x34, 0x1b, 0x68, 0x07, 0xb6, 0xe6, 0x38, 0x59, 0x8c, 0xd0, 0xfe, 0x39, 0x58, 0xf9,
	0x07, 0x78, 0x8e, 0x6f, 0xb4, 0xdb, 0xd8, 0x6e, 0x37, 0xf8, 0xaa, 0xf3, 0x95, 0xb0, 0x0b, 0xef,
	0x5d, 0xe3, 0xcd, 0x25, 0x6b, 0xff, 0xaf, 0x05, 0xd8, 0x5a, 0xfc, 0x92, 0x8e, 0x1e, 0xc1, 0x83,
	0x39, 0x61, 0x9e, 0xf8, 0x54, 0xf3, 0x47, 0xb0, 0x77, 0x9d, 0x99, 0xf7, 0xc8, 0x2a, 0xa0, 0x67,
	0xf0, 0xe1, 0x3b, 0x70, 0xc2, 0x3f, 0xab, 0x88, 0x3e, 0x80, 0xc7, 0x37, 0x20, 0x3b, 0xbc, 0x6a,
	0x9e, 0xc2, 0x93, 0x1b, 0x20, 0xa2, 0xd6, 0x96, 0x0e, 0x7f, 0x59, 0x86, 0x4a, 0x57, 0x75, 0x07,
	0xf4, 0x0a, 0xb6, 0xda, 0x94, 0x2d, 0x78, 0x76, 0x47, 0x1f, 0xe6, 0x5b, 0xc8, 0xa2, 0x57, 0xf9,
	0x9d, 0x87, 0xd7, 0x50, 0x69, 0x87, 0xfa, 0x21, 0x6c, 0x2f, 0x50, 0x2d, 0xff, 0x8e, 0xfa, 0xe8,
	0xed, 0xca, 0xcd, 0xff, 0xb6, 0x6e, 0xa1, 0xde, 0xfc, 0xe3, 0x69, 0xa1, 0xfa, 0x05, 0xff, 0x4c,
	0xdd, 0xa4, 0x3e, 0x80, 0xf7, 0xdb, 0x94, 0xdd, 0xf0, 0xbf, 0x04, 0xfa, 0x24, 0xff, 0x78, 0x7f,
	0xd3, 0xdf, 0x17, 0x37, 0x2d, 0xf5, 0x3d, 0x40, 0xd7, 0x97, 0x42, 0xbb, 0x6f, 0x55, 0xff, 0x2f,
	0xa8, 0x7c, 0x09, 0x0f, 0xae, 0xab, 0xec, 0x92, 0xd8, 0xa7, 0x77, 0xd3, 0xdb, 0x07, 0x2b, 0x0d,
	0xba, 0x6a, 0xbc, 0xe8, 0xfd, 0xb7, 0x9c, 0x35, 0x5a, 0xdd, 0x93, 0xb7, 0xf2, 0xa5, 0xd2, 0xa3,
	0xc3, 0x1f, 0xfc, 0xb7, 0x1b, 0x7a, 0xf4, 0xe0, 0x47, 0xd3, 0x84, 0x05, 0x93, 0x03, 0x76, 0xf5,
	0xdc, 0x0b, 0x12, 0x97, 0x5f, 0xae, 0x67, 0xcf, 0xb5, 0xa8, 0xfc, 0xeb, 0x36, 0xfd, 0xbc, 0x58,
	0x16, 0xdf, 0x9f, 0xfe, 0x33, 0x00, 0x00, 0xff, 0xff, 0xce, 0xc9, 0x24, 0x93, 0xf4, 0x1d, 0x00,
	0x00,
}
