// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/release/trace/events/event.proto

/*
Package events is a generated protocol buffer package.

It is generated from these files:
	code.justin.tv/release/trace/events/event.proto

It has these top-level messages:
	Event
	Extra
	ExtraHTTP
	ExtraSQL
	ExtraMemcached
	ExtraGRPC
	UnusedExtra
	EventSet
*/
package events

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import code_justin_tv_release_trace_common "code.justin.tv/release/trace/common"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Compression int32

const (
	// The data is not compressed.
	Compression_NONE Compression = 0
	// The data is comressed with gzip.
	Compression_GZIP Compression = 1
)

var Compression_name = map[int32]string{
	0: "NONE",
	1: "GZIP",
}
var Compression_value = map[string]int32{
	"NONE": 0,
	"GZIP": 1,
}

func (x Compression) String() string {
	return proto.EnumName(Compression_name, int32(x))
}
func (Compression) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// An Event represents a single Trace-worthy event.  This includes RPC
// lifecycle events (client started to send a request, server finishes sending
// a response), and application-specific custom events.
type Event struct {
	// Lifecycle event this message is attached to
	Kind code_justin_tv_release_trace_common.Kind `protobuf:"varint,1,opt,name=kind,enum=code.justin.tv.release.trace.common.event.Kind" json:"kind,omitempty"`
	// Unix epoch time in nanoseconds, as measured by the process
	Time int64 `protobuf:"fixed64,2,opt,name=time" json:"time,omitempty"`
	// FQDN of the process's host
	Hostname string `protobuf:"bytes,3,opt,name=hostname" json:"hostname,omitempty"`
	// Service name of the process
	Svcname string `protobuf:"bytes,4,opt,name=svcname" json:"svcname,omitempty"`
	// PID of the process
	Pid int32 `protobuf:"varint,5,opt,name=pid" json:"pid,omitempty"`
	// 128-bit identifier for the entire transaction.  This field is sent as
	// two 64-bit integers, least significant word first.
	TransactionId []uint64 `protobuf:"fixed64,6,rep,packed,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	// Identifier for a single RPC span (one request leading to one response).
	// Each level of the distributed call stack adds a new element to the path
	// field.  The value at each level is the (zero-indexed) number of
	// outbound RPC requests made at that level.
	Path []uint32 `protobuf:"varint,7,rep,packed,name=path" json:"path,omitempty"`
	// Additional protocol-specific information
	Extra *Extra `protobuf:"bytes,8,opt,name=extra" json:"extra,omitempty"`
	// Amazon Resource Name for the process's EC2 instance.  This may be sent
	// instead of the hostname field.
	Ec2Arn string `protobuf:"bytes,20,opt,name=ec2_arn,json=ec2Arn" json:"ec2_arn,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Event) GetKind() code_justin_tv_release_trace_common.Kind {
	if m != nil {
		return m.Kind
	}
	return code_justin_tv_release_trace_common.Kind_UNKNOWN
}

func (m *Event) GetTime() int64 {
	if m != nil {
		return m.Time
	}
	return 0
}

func (m *Event) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *Event) GetSvcname() string {
	if m != nil {
		return m.Svcname
	}
	return ""
}

func (m *Event) GetPid() int32 {
	if m != nil {
		return m.Pid
	}
	return 0
}

func (m *Event) GetTransactionId() []uint64 {
	if m != nil {
		return m.TransactionId
	}
	return nil
}

func (m *Event) GetPath() []uint32 {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *Event) GetExtra() *Extra {
	if m != nil {
		return m.Extra
	}
	return nil
}

func (m *Event) GetEc2Arn() string {
	if m != nil {
		return m.Ec2Arn
	}
	return ""
}

// An Extra describes protocol-specific information to be associated with an
// Event.
type Extra struct {
	// The address of the peer.  This could be an ipv4:port pair, [ipv6]:port
	// pair, or hostname:port pair for TCP/UDP-based protocols, a bare IP
	// address or hostname for IP- based protocols, or a path to a unix domain
	// socket.
	//
	// This field is NOT an attempt to identify the client, e.g. via the HTTP
	// X-Forwarded-For header.
	Peer string `protobuf:"bytes,1,opt,name=peer" json:"peer,omitempty"`
	// Additional HTTP-specific information for the Event.
	Http *ExtraHTTP `protobuf:"bytes,2,opt,name=http" json:"http,omitempty"`
	// Additional SQL-specific information for the Event.
	Sql *ExtraSQL `protobuf:"bytes,3,opt,name=sql" json:"sql,omitempty"`
	// Additional Memcached-specific information for the Event.
	Memcached *ExtraMemcached `protobuf:"bytes,4,opt,name=memcached" json:"memcached,omitempty"`
	// Additional gRPC-specific information for the Event.
	Grpc *ExtraGRPC `protobuf:"bytes,5,opt,name=grpc" json:"grpc,omitempty"`
}

func (m *Extra) Reset()                    { *m = Extra{} }
func (m *Extra) String() string            { return proto.CompactTextString(m) }
func (*Extra) ProtoMessage()               {}
func (*Extra) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Extra) GetPeer() string {
	if m != nil {
		return m.Peer
	}
	return ""
}

func (m *Extra) GetHttp() *ExtraHTTP {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *Extra) GetSql() *ExtraSQL {
	if m != nil {
		return m.Sql
	}
	return nil
}

func (m *Extra) GetMemcached() *ExtraMemcached {
	if m != nil {
		return m.Memcached
	}
	return nil
}

func (m *Extra) GetGrpc() *ExtraGRPC {
	if m != nil {
		return m.Grpc
	}
	return nil
}

// An ExtraHTTP describes HTTP-specific information to be associated with an
// Event.
type ExtraHTTP struct {
	// Status code of HTTP response.  Common values will include 200 or 404.
	// Values less than zero indicate an error observed by the client which
	// caused it to give up on the request before getting a status code from
	// the server.
	StatusCode int32 `protobuf:"zigzag32,1,opt,name=status_code,json=statusCode" json:"status_code,omitempty"`
	// Method of HTTP request.
	Method code_justin_tv_release_trace_common.Method `protobuf:"varint,2,opt,name=method,enum=code.justin.tv.release.trace.common.http.Method" json:"method,omitempty"`
	// Path of the HTTP request.  This is only the path - the scheme,
	// hostname, query, and fragment are not included.
	UriPath string `protobuf:"bytes,16,opt,name=uri_path,json=uriPath" json:"uri_path,omitempty"`
}

func (m *ExtraHTTP) Reset()                    { *m = ExtraHTTP{} }
func (m *ExtraHTTP) String() string            { return proto.CompactTextString(m) }
func (*ExtraHTTP) ProtoMessage()               {}
func (*ExtraHTTP) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ExtraHTTP) GetStatusCode() int32 {
	if m != nil {
		return m.StatusCode
	}
	return 0
}

func (m *ExtraHTTP) GetMethod() code_justin_tv_release_trace_common.Method {
	if m != nil {
		return m.Method
	}
	return code_justin_tv_release_trace_common.Method_UNKNOWN
}

func (m *ExtraHTTP) GetUriPath() string {
	if m != nil {
		return m.UriPath
	}
	return ""
}

// An ExtraSQL describes SQL-specific information to be associated with an
// Event.
type ExtraSQL struct {
	// Name of the target database.
	DatabaseName string `protobuf:"bytes,1,opt,name=database_name,json=databaseName" json:"database_name,omitempty"`
	// Username used to connect to the target database.
	DatabaseUser string `protobuf:"bytes,2,opt,name=database_user,json=databaseUser" json:"database_user,omitempty"`
	// Query string with all user data removed: e.g. strings replaced by '',
	// integers replaced by 0, etc.  This value may be truncated (particularly
	// if it's larger than 1kB).
	StrippedQuery string `protobuf:"bytes,16,opt,name=stripped_query,json=strippedQuery" json:"stripped_query,omitempty"`
}

func (m *ExtraSQL) Reset()                    { *m = ExtraSQL{} }
func (m *ExtraSQL) String() string            { return proto.CompactTextString(m) }
func (*ExtraSQL) ProtoMessage()               {}
func (*ExtraSQL) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ExtraSQL) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

func (m *ExtraSQL) GetDatabaseUser() string {
	if m != nil {
		return m.DatabaseUser
	}
	return ""
}

func (m *ExtraSQL) GetStrippedQuery() string {
	if m != nil {
		return m.StrippedQuery
	}
	return ""
}

// An ExtraMemcached describes memcached-specific information to be
// associated with an event. Most of this was written with the
// assistance of the memcached protocol spec at
// https://github.com/memcached/memcached/blob/c10feb9ebe2179f6fbe4ac2e3cd12bfefdd42631/doc/protocol.txt.
type ExtraMemcached struct {
	// The command sent to memcached by a client
	Command code_justin_tv_release_trace_common.Command `protobuf:"varint,1,opt,name=command,enum=code.justin.tv.release.trace.common.memcached.Command" json:"command,omitempty"`
	// The number of keys in this memcached event. This is useful
	// for understanding bulk transactions: the request side might
	// ask for 150 keys, but the response side might have only
	// 100, indicating that the cache was hit for 100 out of the
	// 150 requested keys.
	NKeys uint32 `protobuf:"varint,2,opt,name=n_keys,json=nKeys" json:"n_keys,omitempty"`
	// Some commands involve the client setting a 32-bit integer
	// expiration time. According to the memcached protocol spec,
	// this may be either a Unix time, or a number of seconds
	// starting from current time. The memcached server decides
	// which it is by the size of the expiration time: if the
	// value is less than or equal to 60*60*24*30 (30 days), then
	// it's taken as a relative expiration; if it's over this
	// amount then it is interpreted as Unix time. If its set to
	// zero, then the item never expires.
	Expiration uint32 `protobuf:"fixed32,3,opt,name=expiration" json:"expiration,omitempty"`
}

func (m *ExtraMemcached) Reset()                    { *m = ExtraMemcached{} }
func (m *ExtraMemcached) String() string            { return proto.CompactTextString(m) }
func (*ExtraMemcached) ProtoMessage()               {}
func (*ExtraMemcached) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ExtraMemcached) GetCommand() code_justin_tv_release_trace_common.Command {
	if m != nil {
		return m.Command
	}
	return code_justin_tv_release_trace_common.Command_UNKNOWN_COMMAND
}

func (m *ExtraMemcached) GetNKeys() uint32 {
	if m != nil {
		return m.NKeys
	}
	return 0
}

func (m *ExtraMemcached) GetExpiration() uint32 {
	if m != nil {
		return m.Expiration
	}
	return 0
}

// An ExtraGRPC describes gRPC-specific information to be associated with an
// event.
type ExtraGRPC struct {
	// Fully-qualified method name, including proto package name, service
	// name, and method name.
	Method string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
}

func (m *ExtraGRPC) Reset()                    { *m = ExtraGRPC{} }
func (m *ExtraGRPC) String() string            { return proto.CompactTextString(m) }
func (*ExtraGRPC) ProtoMessage()               {}
func (*ExtraGRPC) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ExtraGRPC) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

// An UnusedExtra describes protocol-specific information to be associated
// with an Event.  This message is not yet ready for use, meaning that the
// field names, identities, and numbers are subject to change!
type UnusedExtra struct {
	// written by an engineer - "string" means utf-8 encoded, which should be
	// fine?
	Text          string `protobuf:"bytes,20,opt,name=text" json:"text,omitempty"`
	TextTruncated bool   `protobuf:"varint,1020,opt,name=text_truncated,json=textTruncated" json:"text_truncated,omitempty"`
	// if there's a payload, how big is it?
	PayloadSize int64 `protobuf:"varint,21,opt,name=payload_size,json=payloadSize" json:"payload_size,omitempty"`
	// request uri
	HttpUri          string `protobuf:"bytes,41,opt,name=http_uri,json=httpUri" json:"http_uri,omitempty"`
	HttpUriTruncated bool   `protobuf:"varint,1041,opt,name=http_uri_truncated,json=httpUriTruncated" json:"http_uri_truncated,omitempty"`
	// headers, partial list
	HttpHeader []*UnusedExtra_KV `protobuf:"bytes,43,rep,name=http_header,json=httpHeader" json:"http_header,omitempty"`
	// if there are headers that we expect to be very long, we may want to
	// pull them out into their own fields so we can note when we truncate
	// them
	HttpReferer          string `protobuf:"bytes,44,opt,name=http_referer,json=httpReferer" json:"http_referer,omitempty"`
	HttpRefererTruncated bool   `protobuf:"varint,1044,opt,name=http_referer_truncated,json=httpRefererTruncated" json:"http_referer_truncated,omitempty"`
}

func (m *UnusedExtra) Reset()                    { *m = UnusedExtra{} }
func (m *UnusedExtra) String() string            { return proto.CompactTextString(m) }
func (*UnusedExtra) ProtoMessage()               {}
func (*UnusedExtra) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *UnusedExtra) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *UnusedExtra) GetTextTruncated() bool {
	if m != nil {
		return m.TextTruncated
	}
	return false
}

func (m *UnusedExtra) GetPayloadSize() int64 {
	if m != nil {
		return m.PayloadSize
	}
	return 0
}

func (m *UnusedExtra) GetHttpUri() string {
	if m != nil {
		return m.HttpUri
	}
	return ""
}

func (m *UnusedExtra) GetHttpUriTruncated() bool {
	if m != nil {
		return m.HttpUriTruncated
	}
	return false
}

func (m *UnusedExtra) GetHttpHeader() []*UnusedExtra_KV {
	if m != nil {
		return m.HttpHeader
	}
	return nil
}

func (m *UnusedExtra) GetHttpReferer() string {
	if m != nil {
		return m.HttpReferer
	}
	return ""
}

func (m *UnusedExtra) GetHttpRefererTruncated() bool {
	if m != nil {
		return m.HttpRefererTruncated
	}
	return false
}

// if we use proto3 we can just use maps
type UnusedExtra_KV struct {
	// option map_entry = true;
	Key   string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *UnusedExtra_KV) Reset()                    { *m = UnusedExtra_KV{} }
func (m *UnusedExtra_KV) String() string            { return proto.CompactTextString(m) }
func (*UnusedExtra_KV) ProtoMessage()               {}
func (*UnusedExtra_KV) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0} }

func (m *UnusedExtra_KV) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *UnusedExtra_KV) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// An EventSet is a list of Events.  It may be used when sending multiple
// events in a datagram, or when saving them to disk.  There is no codified or
// implied relation between Events grouped into an EventSet.
//
// The EventSet can just be a wrapper to indicate that it holds a
// compressed EventSet. If this is the case, the compression field
// will indicate the compression codec.
type EventSet struct {
	// List of Events, if (and only if) the data is uncompressed.
	Event []*Event `protobuf:"bytes,1,rep,name=event" json:"event,omitempty"`
	// A compressed EventSet. If this is set, then the event field should be empty.
	CompressedEventSet []byte `protobuf:"bytes,2,opt,name=compressed_event_set,json=compressedEventSet,proto3" json:"compressed_event_set,omitempty"`
	// The compression codec used to encode compressed_event_set.
	Compression Compression `protobuf:"varint,3,opt,name=compression,enum=code.justin.tv.release.trace.events.Compression" json:"compression,omitempty"`
}

func (m *EventSet) Reset()                    { *m = EventSet{} }
func (m *EventSet) String() string            { return proto.CompactTextString(m) }
func (*EventSet) ProtoMessage()               {}
func (*EventSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *EventSet) GetEvent() []*Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *EventSet) GetCompressedEventSet() []byte {
	if m != nil {
		return m.CompressedEventSet
	}
	return nil
}

func (m *EventSet) GetCompression() Compression {
	if m != nil {
		return m.Compression
	}
	return Compression_NONE
}

func init() {
	proto.RegisterType((*Event)(nil), "code.justin.tv.release.trace.events.Event")
	proto.RegisterType((*Extra)(nil), "code.justin.tv.release.trace.events.Extra")
	proto.RegisterType((*ExtraHTTP)(nil), "code.justin.tv.release.trace.events.ExtraHTTP")
	proto.RegisterType((*ExtraSQL)(nil), "code.justin.tv.release.trace.events.ExtraSQL")
	proto.RegisterType((*ExtraMemcached)(nil), "code.justin.tv.release.trace.events.ExtraMemcached")
	proto.RegisterType((*ExtraGRPC)(nil), "code.justin.tv.release.trace.events.ExtraGRPC")
	proto.RegisterType((*UnusedExtra)(nil), "code.justin.tv.release.trace.events.UnusedExtra")
	proto.RegisterType((*UnusedExtra_KV)(nil), "code.justin.tv.release.trace.events.UnusedExtra.KV")
	proto.RegisterType((*EventSet)(nil), "code.justin.tv.release.trace.events.EventSet")
	proto.RegisterEnum("code.justin.tv.release.trace.events.Compression", Compression_name, Compression_value)
}

func init() { proto.RegisterFile("code.justin.tv/release/trace/events/event.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 869 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xcd, 0x72, 0xdc, 0x44,
	0x10, 0x8e, 0xf6, 0x57, 0x6e, 0x79, 0xb7, 0x96, 0x29, 0xc7, 0x08, 0x1f, 0x40, 0x59, 0x17, 0x94,
	0x12, 0x12, 0xad, 0x6b, 0x53, 0x70, 0xe0, 0x02, 0x78, 0xcb, 0x15, 0xa7, 0x4c, 0xcc, 0x7a, 0x6c,
	0xe7, 0x90, 0x8b, 0x6a, 0x22, 0x35, 0xac, 0xb0, 0x57, 0x52, 0x66, 0x46, 0x2e, 0x6f, 0x78, 0x8a,
	0x54, 0x71, 0x80, 0x27, 0xe1, 0x0d, 0x78, 0x00, 0x9e, 0x87, 0x03, 0x35, 0x2d, 0x69, 0xad, 0x5c,
	0xc2, 0x72, 0x52, 0x4f, 0x4f, 0x7f, 0x5f, 0xff, 0x8f, 0x60, 0x12, 0x65, 0x31, 0x06, 0xbf, 0x14,
	0x4a, 0x27, 0x69, 0xa0, 0x6f, 0x26, 0x12, 0xaf, 0x51, 0x28, 0x9c, 0x68, 0x29, 0x22, 0x9c, 0xe0,
	0x0d, 0xa6, 0x5a, 0x95, 0x9f, 0x20, 0x97, 0x99, 0xce, 0xd8, 0xfe, 0xfb, 0x80, 0xa0, 0x02, 0x04,
	0x04, 0x08, 0x4a, 0xc0, 0xde, 0xc1, 0x07, 0x59, 0xa3, 0x6c, 0xb9, 0xcc, 0xd2, 0xea, 0x53, 0xd2,
	0x8e, 0xff, 0x6a, 0x41, 0xf7, 0xc8, 0x80, 0xd9, 0x0c, 0x3a, 0x57, 0x49, 0x1a, 0xbb, 0x96, 0x67,
	0xf9, 0xc3, 0xe9, 0x24, 0xf8, 0xa0, 0xbf, 0x8a, 0xa3, 0x0c, 0xf0, 0x24, 0x49, 0x63, 0x4e, 0x60,
	0xc6, 0xa0, 0xa3, 0x93, 0x25, 0xba, 0x2d, 0xcf, 0xf2, 0x47, 0x9c, 0x64, 0xb6, 0x07, 0xf6, 0x22,
	0x53, 0x3a, 0x15, 0x4b, 0x74, 0xdb, 0x9e, 0xe5, 0x6f, 0xf1, 0xf5, 0x99, 0xb9, 0xd0, 0x57, 0x37,
	0x11, 0x5d, 0x75, 0xe8, 0xaa, 0x3e, 0xb2, 0x11, 0xb4, 0xf3, 0x24, 0x76, 0xbb, 0x9e, 0xe5, 0x77,
	0xb9, 0x11, 0xd9, 0x43, 0x18, 0x6a, 0x29, 0x52, 0x25, 0x22, 0x9d, 0x64, 0x69, 0x98, 0xc4, 0x6e,
	0xcf, 0x6b, 0xfb, 0xbd, 0xc3, 0xd6, 0xc8, 0xe2, 0x83, 0xc6, 0xcd, 0xf3, 0x98, 0xed, 0x42, 0x27,
	0x17, 0x7a, 0xe1, 0xf6, 0xbd, 0xb6, 0x3f, 0x20, 0x03, 0x3a, 0xb3, 0xef, 0xa0, 0x8b, 0xb7, 0x5a,
	0x0a, 0xd7, 0xf6, 0x2c, 0xdf, 0x99, 0x3e, 0x0a, 0x36, 0x28, 0x6a, 0x70, 0x64, 0x10, 0xbc, 0x04,
	0xb2, 0x8f, 0xa1, 0x8f, 0xd1, 0x34, 0x14, 0x32, 0x75, 0x77, 0x28, 0xe0, 0x1e, 0x46, 0xd3, 0xef,
	0x65, 0x3a, 0xfe, 0xd3, 0x14, 0x92, 0x4c, 0x18, 0x74, 0x72, 0x44, 0x49, 0x85, 0xdc, 0xe2, 0x24,
	0xb3, 0x43, 0xe8, 0x2c, 0xb4, 0xce, 0xa9, 0x2e, 0xce, 0x34, 0xd8, 0xdc, 0xef, 0xf1, 0xc5, 0xc5,
	0x9c, 0x13, 0x96, 0x7d, 0x0b, 0x6d, 0xf5, 0xe6, 0x9a, 0x4a, 0xe8, 0x4c, 0x9f, 0x6c, 0x4e, 0x71,
	0x7e, 0xf6, 0x03, 0x37, 0x48, 0x76, 0x06, 0x5b, 0x4b, 0x5c, 0x46, 0x22, 0x5a, 0x60, 0x4c, 0xe5,
	0x76, 0xa6, 0x4f, 0x37, 0xa7, 0x79, 0x51, 0x43, 0xf9, 0x1d, 0x8b, 0xc9, 0xeb, 0x67, 0x99, 0x47,
	0xd4, 0xa6, 0xff, 0x95, 0xd7, 0x33, 0x3e, 0x9f, 0x71, 0xc2, 0x8e, 0xdf, 0x59, 0xb0, 0xb5, 0xce,
	0x95, 0x7d, 0x06, 0x8e, 0xd2, 0x42, 0x17, 0x2a, 0x34, 0x5c, 0x54, 0xc4, 0x8f, 0x38, 0x94, 0xaa,
	0x59, 0x16, 0x23, 0x3b, 0x86, 0xde, 0x12, 0xf5, 0x22, 0x8b, 0xa9, 0x98, 0xc3, 0xe9, 0xc1, 0x46,
	0x93, 0x6a, 0x2a, 0x18, 0xbc, 0x20, 0x1c, 0xaf, 0xf0, 0xec, 0x13, 0xb0, 0x0b, 0x99, 0x84, 0x34,
	0x29, 0xa3, 0x72, 0xfa, 0x0a, 0x99, 0xcc, 0x85, 0x5e, 0x8c, 0x7f, 0x05, 0xbb, 0xae, 0x1d, 0xdb,
	0x87, 0x41, 0x2c, 0xb4, 0x78, 0x2d, 0x14, 0x86, 0x34, 0xa9, 0x65, 0x63, 0xb7, 0x6b, 0xe5, 0xa9,
	0x19, 0xd7, 0xa6, 0x51, 0xa1, 0x50, 0x52, 0x70, 0x0d, 0xa3, 0x4b, 0x85, 0x92, 0x7d, 0x0e, 0x43,
	0xa5, 0x65, 0x92, 0xe7, 0x18, 0x87, 0x6f, 0x0a, 0x94, 0xab, 0xca, 0xed, 0xa0, 0xd6, 0x9e, 0x19,
	0xe5, 0xf8, 0x0f, 0x0b, 0x86, 0xef, 0x97, 0x9c, 0xcd, 0xa1, 0x6f, 0x12, 0x11, 0xeb, 0xfd, 0xfc,
	0x7a, 0xa3, 0xac, 0xd7, 0x8d, 0x0a, 0x66, 0x25, 0x9a, 0xd7, 0x34, 0xec, 0x3e, 0xf4, 0xd2, 0xf0,
	0x0a, 0x57, 0x8a, 0x22, 0x1d, 0xf0, 0x6e, 0x7a, 0x82, 0x2b, 0xc5, 0x3e, 0x05, 0xc0, 0xdb, 0x3c,
	0x91, 0xc2, 0x6c, 0x12, 0xcd, 0x5a, 0x9f, 0x37, 0x34, 0xe3, 0xfd, 0xaa, 0x57, 0xa6, 0x7f, 0x6c,
	0x77, 0xdd, 0x8a, 0xb2, 0x24, 0xd5, 0x69, 0xfc, 0x7b, 0x1b, 0x9c, 0xcb, 0xb4, 0x50, 0x18, 0xaf,
	0x37, 0x42, 0xe3, 0xad, 0xae, 0x36, 0x86, 0x64, 0xf6, 0x05, 0x0c, 0xcd, 0x37, 0xd4, 0xb2, 0x48,
	0x23, 0xa1, 0x31, 0x76, 0xff, 0xe9, 0x7b, 0x96, 0x6f, 0xf3, 0x81, 0x51, 0x5f, 0xd4, 0x5a, 0xf6,
	0x00, 0xb6, 0x73, 0xb1, 0xba, 0xce, 0x44, 0x1c, 0xaa, 0xe4, 0x2d, 0xba, 0xf7, 0x3d, 0xcb, 0x6f,
	0x73, 0xa7, 0xd2, 0x9d, 0x27, 0x6f, 0xd1, 0xf4, 0xd1, 0xb4, 0x37, 0x2c, 0x64, 0xe2, 0x3e, 0x2c,
	0xfb, 0x68, 0xce, 0x97, 0x32, 0x61, 0x4f, 0x80, 0xd5, 0x57, 0x0d, 0x4f, 0xef, 0x6c, 0xf2, 0x34,
	0xaa, 0xac, 0xee, 0x9c, 0x5d, 0x80, 0x43, 0xe6, 0x0b, 0x14, 0x31, 0x4a, 0xf7, 0x4b, 0xaf, 0xbd,
	0xf1, 0x8e, 0x34, 0xf2, 0x0d, 0x4e, 0x5e, 0x72, 0x30, 0x3c, 0xc7, 0x44, 0x63, 0x52, 0x20, 0x56,
	0x89, 0x3f, 0xa1, 0x44, 0xe9, 0x3e, 0xa6, 0x18, 0xc9, 0x13, 0x2f, 0x55, 0xec, 0x2b, 0xd8, 0x6d,
	0x9a, 0x34, 0x62, 0xfd, 0xad, 0x8c, 0x75, 0xa7, 0x61, 0xbd, 0x8e, 0x77, 0xef, 0x31, 0xb4, 0x4e,
	0x5e, 0x9a, 0xa7, 0xf2, 0x0a, 0x57, 0x55, 0x0f, 0x8c, 0xc8, 0x76, 0xa0, 0x7b, 0x23, 0xae, 0x0b,
	0xac, 0xa6, 0xb0, 0x3c, 0x7c, 0xd3, 0x72, 0xad, 0xf1, 0xdf, 0x16, 0xd8, 0xf4, 0xde, 0x9f, 0xa3,
	0xa6, 0xe7, 0xd0, 0xc8, 0xae, 0x45, 0x89, 0x6e, 0xf8, 0x1c, 0x9a, 0x0f, 0x2f, 0x81, 0xec, 0x00,
	0x76, 0xa2, 0x6c, 0x99, 0x4b, 0x54, 0x0a, 0xe3, 0x90, 0x74, 0xa1, 0x42, 0x4d, 0x7e, 0xb7, 0x39,
	0xbb, 0xbb, 0x5b, 0xfb, 0xe4, 0xe0, 0xd4, 0xda, 0x7a, 0xc2, 0xfe, 0x73, 0x87, 0x2b, 0xcf, 0xb3,
	0x3b, 0x1c, 0x6f, 0x92, 0x3c, 0x7a, 0x00, 0x4e, 0xe3, 0x8e, 0xd9, 0xd0, 0x39, 0xfd, 0xf1, 0xf4,
	0x68, 0x74, 0xcf, 0x48, 0xcf, 0x5e, 0x3d, 0x9f, 0x8f, 0xac, 0x43, 0xfb, 0x55, 0xaf, 0x64, 0x99,
	0xdf, 0x7b, 0xdd, 0xa3, 0x5f, 0xdf, 0xd3, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x77, 0x0f, 0xc8,
	0x6c, 0x84, 0x07, 0x00, 0x00,
}
