package hystrix

import (
	"github.com/cep21/circuit/v3"
	"github.com/cep21/circuit/v3/closers/hystrix"
)

// generated by goforward github.com/cep21/circuit/v3/closers/hystrix github.com/cep21/circuit/closers/hystrix

// Closer is hystrix's default half-open logic: try again ever X ms
type Closer = hystrix.Closer

// CloserFactory creates Closer closer
func CloserFactory(config ConfigureCloser) func() circuit.OpenToClosed {
	return hystrix.CloserFactory(config)
}

// ConfigureCloser configures values for Closer
type ConfigureCloser = hystrix.ConfigureCloser

// Factory aids making hystrix circuit logic
type Factory = hystrix.Factory

// Opener is ClosedToOpen that opens a circuit after a threshold and % error has been
// reached.  It is the default hystrix implementation.
type Opener = hystrix.Opener

// OpenerFactory creates a err % opener
func OpenerFactory(config ConfigureOpener) func() circuit.ClosedToOpen {
	return hystrix.OpenerFactory(config)
}

// ConfigureOpener configures Opener
type ConfigureOpener = hystrix.ConfigureOpener
