# Sauron

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=cb-sauron-build)](https://jenkins.internal.justin.tv/job/cb-sauron-build)

Sauron collects channel activity across twitch and unifies them by channel. It runs Activity Feed on the live dashboard and powers alert statuses for the Spotlight broadcasting software.

## Service Resources
| Resource            |
|---------------------|
| [Runbook](./docs/runbook.md) |
| [Dashboard](https://grafana.xarth.tv/d/JkVhfvRZk/sauron)       | 
| [Slack](https://twitch.slack.com/archives/C2VA4EXN0)           |
| [Pagerduty](https://twitchoncall.pagerduty.com/services/PH7QEWY)       |
| [Service Catalog](https://servicecatalog.internal.justin.tv/services/532) |
| [SLA](/docs/sla.md) |
| [Deploying](/docs/deployment.md) |
| [Jenkins Build](https://jenkins.internal.justin.tv/view/Creator%20Business/job/cb-sauron-build/) |
| [Jenkins Deploy](https://jenkins.internal.justin.tv/view/Creator%20Business/job/cb-sauron-deploy/) |
| [Jarvis](https://jarvis.xarth.tv/availability/service/2020/m03?service_id=532) |
| [Rollbar Logs](https://rollbar.com/Twitch/CB_Sauron/items) |
| [API](./docs/api.md) |
| [Adding a new Activity](./docs/activity.md#adding-a-new-activity) |

Please consult the [docs](./docs) for more details, including design and architecture choices.

## Table of Contents
1. [Service Links](#service-links)
2. [Usage](#usage)
3. [Development](#development)
    1. [Dependencies](#dependencies)
4. [Pubsub Integration](#pubsub-integration)
5. [Adding/Changing Activities](#adding-or-changing-activities)

## Service Links
| Environment | AWS Account | DNS Name |
|-------------|-------------|----------|
| staging     | [twitch-cb-aws](https://twitch-cb-aws.signin.aws.amazon.com/console) | http://staging.sauron.cb.twitch.a2z.com |
| production  | [twitch-cb-aws](https://twitch-cb-aws.signin.aws.amazon.com/console) | http://prod.sauron.cb.twitch.a2z.com |

## Usage
Sauron uses [twirp](https://twitchtv.github.io/twirp/) for client generation. You can use the client like this:

```go
import (
    "context"
    "http"

    "code.justin.tv/cb/sauron/rpc/sauron"
)

client := sauron.NewSauronProtobufClient("http://localhost:8000", http.DefaultClient)
request := &sauron.GetActivitiesReq{
    ChannelID: "123456",
    Cursor: "",
    Limit: 100,
}
resp, err := client.GetActivities(context.Background(), request)
...
```

Additional API documentation can be found [here](./docs/api.md). You can also check the service definition in the [proto file](./rpc/sauron/service.proto).

## Development

Sauron does not use Go Modules. You should clone this repo into your GOPATH, for example:
```
~/go/src/code.justin.tv/cb/sauron
```

If you have go and homebrew installed, run `make setup` to install project dependencies. Further instructions are located in [Setup](./docs/setup.md).

The [makefile](./Makefile) contains some useful commands for development:
1. `make lint`: runs golangci-lint
2. `make test`: runs all unit tests
3. `make run`: starts a server locally
4. `make mocks`: generates test mocks for dependencies
5. `make proto`: generates the twirp service definition

If you want to add a new activity type to sauron, see the steps [here](/docs/activity.md)

### Dependencies
Sauron relies on the following dependencies. They can be installed individually using `brew install ...`, `go get ...`, or using the `make setup` command.
1. `mockery`: generates unit test mocks
2. `convey`: bdd unit testing library
3. `golangci-lint`: lints go code
4. `protoc`: generates protobuf/twirp services
5. `dep`: dependency management
6. `clang-format`: formats `.proto` files
7. `terraform`: infrastructure management

## Pubsub Integration
To confirm a PubSub integration, see [Validating Integration](./docs/pubsub.md#validating-integration).

## Adding or Changing Activities
If you need to add a new activity for the activity feed, or wish to add, remove or modify fields or behavior for an existing activity, see the docs on [Adding a new Activity](./docs/activity.md).
