package api

import "errors"

// Errors caused by the client/Lambda invoker:
var (
	ErrInvalidChannelID = errors.New("invalid channel id")
	ErrInvalidCursor    = errors.New("invalid cursor")
)

// ErrorResponse is the expected JSON signature of errors returned by a function invocation.
// See https://docs.aws.amazon.com/lambda/latest/dg/go-programming-model-errors.html.
type ErrorResponse struct {
	ErrorMessage string `json:"errorMessage"`
	ErrorType    string `json:"errorType"`
}

// Error implements the error interface.
func (r ErrorResponse) Error() string {
	return r.ErrorMessage
}
