// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-03-15 11:26:13.473599 -0700 PDT m=+0.008471951
// Template path: handler_definitions/templates/activity/pubsub/activity.go.tmpl

package pubsub

import (
	"time"

	"code.justin.tv/cb/sauron/types"
)

// Activity contains all other nullable activity type-specific metadata.
//
// A nullable field may be used for more than one activity type.
//
// This PubSub schema was designed to be as similar to the GraphQL schema as possible:
// https://git.xarth.tv/edge/graphql/blob/master/schema/types/dashboard_activity_feed.graphql
//
// The letter casing here is different than that of GQL,
// because the Chat team's PubSub system by convention uses snake case in JSON.
type Activity struct {
	ID        string    `json:"id"`
	Timestamp time.Time `json:"timestamp"`
	Type      string    `json:"type"`

	BitsAmount    *int64      `json:"bits_amount,omitempty"`
	BitsAnonymous *bool       `json:"bits_anonymous,omitempty"`
	BitsUser      *types.User `json:"bits_user,omitempty"` // nil if BitsAnonymous

	Follower *types.User `json:"follower,omitempty"`

	Host               *types.User `json:"host,omitempty"`
	HostingViewerCount *int        `json:"hosting_viewer_count,omitempty"`

	Raider             *types.User `json:"raider,omitempty"`
	RaidingViewerCount *int32      `json:"raiding_viewer_count,omitempty"`
	Status             *int32      `json:"status,omitempty"`

	Subscriber                         *types.User      `json:"subscriber,omitempty"`
	SubscriptionTier                   *string          `json:"subscription_tier,omitempty"`
	SubscriptionCumulativeTenureMonths *int             `json:"subscription_cumulative_tenure_months,omitempty"`
	SubscriptionCustomMessageFragments []types.Fragment `json:"subscription_custom_message_fragments,omitempty"` // SubscriptionCustomMessageFragments contain metadata to enrich SubscriptionCustomMessageText at specific substrings
	SubscriptionCustomMessageText      *string          `json:"subscription_custom_message_text,omitempty"`      // SubscriptionCustomMessageText is the original message shared by the Subscriber, filtered with moderation rules
	SubscriptionMultiMonthDuration     *int             `json:"subscription_multi_month_duration,omitempty"`
	SubscriptionMultiMonthTenure       *int             `json:"subscription_multi_month_tenure,omitempty"`

	SubscriptionGifter          *types.User `json:"subscription_gifter,omitempty"` // nil if SubscriptionGiftAnonymous
	SubscriptionGiftAnonymous   *bool       `json:"subscription_gift_anonymous,omitempty"`
	SubscriptionGiftQuantity    *int        `json:"subscription_gift_quantity,omitempty"`
	SubscriptionGiftRecipient   *types.User `json:"subscription_gift_recipient,omitempty"`
	SubscriptionGiftTier        *string     `json:"subscription_gift_tier,omitempty"`
	SubscriptionGiftMonthAmount *int        `json:"subscription_gift_month_amount,omitempty"`

	BoostOrderGoalProgress *int        `json:"boost_order_goal_progress,omitempty"`
	BoostOrderGoalTarget   *int        `json:"boost_order_goal_target,omitempty"`
	BoostOrderQuantity     *int        `json:"boost_order_quantity,omitempty"`
	BoostOrderPurchaser    *types.User `json:"boost_order_purchaser,omitempty"`

	CelebrationPurchasingUser *types.User `json:"celebration_purchasing_user,omitempty"`
	Intensity                 *string     `json:"intensity,omitempty"`
	Effect                    *string     `json:"effect,omitempty"`

	ChannelPointsRedemptionID  *string     `json:"channel_points_redemption_id,omitempty"`
	ChannelPointsRedeemingUser *types.User `json:"channel_points_redeeming_user,omitempty"`
	ChannelPointsRewardID      *string     `json:"channel_points_reward_id,omitempty"`
	ChannelPointsRewardTitle   *string     `json:"channel_points_reward_title,omitempty"`
	ChannelPointsUserInput     *string     `json:"channel_points_user_input,omitempty"` // Expected to be null where the reward doesn't take user input.

	ChannelPointsGoalID            *string `json:"channel_points_goal_id,omitempty"`
	ChannelPointsGoalTitle         *string `json:"channel_points_goal_title,omitempty"`
	ChannelPointsPointsContributed *int    `json:"channel_points_points_contributed,omitempty"`
	ChannelPointsGoalAmount        *int    `json:"channel_points_goal_amount,omitempty"`
	ChannelPointsGoalStatus        *string `json:"channel_points_goal_status,omitempty"`
	ChannelPointsGoalType          *string `json:"channel_points_goal_type,omitempty"`
	ChannelPointsName              *string `json:"channel_points_name,omitempty"`

	DropName          *string `json:"drop_name,omitempty"`
	DropInstanceID    *string `json:"drop_instance_id,omitempty"`
	DropQuestName     *string `json:"quest_name,omitempty"`
	DropClaimDuration *int32  `json:"claim_duration,omitempty"`

	HypeTrainID             *string `json:"hype_train_id,omitempty"`
	HypeTrainEventType      *string `json:"hype_train_event_type,omitempty"`
	HypeTrainCompletedLevel *int    `json:"hype_train_completed_level,omitempty"`
	HypeTrainTotalSubs      *int    `json:"hype_train_total_subs,omitempty"`
	HypeTrainTotalBits      *int    `json:"hype_train_total_bits,omitempty"`

	AlertStatus *string `json:"alert_status,omitempty"`
}
