package defs

import "log"

type Activity struct {
	Name          string   `json:"name"`
	PrettyName    string   `json:"pretty_name"`
	Description   string   `json:"description"`
	IgnoreFields  []string `json:"ignore_fields"`
	IncludeFields []string `json:"include_fields"`
	fields        []Field
	validFields   []Field
}

func (a *Activity) fix(definition *Handler, path string, idx int) {
	if a.Name == "" {
		log.Fatalf("No 'name' found in service %d of %s", idx, path)
	}
	if a.PrettyName == "" {
		a.PrettyName = makePrettyName(a.Name)
	}
	if len(a.fields) == 0 {
		a.fields = definition.Fields
	}
	if len(a.IgnoreFields) == 0 {
		a.IgnoreFields = definition.IgnoreFields
	}
	if len(a.IncludeFields) == 0 {
		a.IncludeFields = definition.IncludeFields
	}
}

func (a *Activity) ValidFields() []Field {
	if len(a.validFields) > 0 {
		return a.validFields
	}

	if len(a.IgnoreFields) == 0 && len(a.IncludeFields) == 0 {
		a.validFields = a.fields
	} else {
		result := filterValidFields(a.fields, a.IncludeFields, a.IgnoreFields)
		a.validFields = result
	}

	return a.validFields
}
