package defs

import "log"

type Alert struct {
	ID           int    `json:"id"`
	Name         string `json:"name"`
	VariableName string `json:"variable_name"`
}

func (a *Alert) fix(templateInfo *TemplateInfo, path, prettyName string) {
	if a.ID > 0 {
		for _, usedID := range templateInfo.AlertIDs {
			if usedID == a.ID {
				log.Fatalf("%q has an alert ID of %d but that has already been used by another alert", path, usedID)
			}
		}
		templateInfo.AlertIDs = append(templateInfo.AlertIDs, a.ID)
		if a.Name == "" {
			a.Name = prettyName + "Data"
		}
		if a.VariableName == "" {
			a.VariableName = variableName(prettyName)
		}

	}
}

func (a *Alert) HasAlert() bool {
	return a.ID != 0
}
