package defs

import "log"

type EventBus struct {
	EventType   string `json:"event_type"`
	EventImport string `json:"event_import"`
	ChannelID   string `json:"channel_id_property"`
}

func (s *EventBus) fix(path string) {
	if s.EventType == "" {
		log.Fatalf("No 'event_type' found in 'event_bus' of %s", path)
	}

	if s.EventImport == "" {
		log.Fatalf("No 'event_import' found in 'event_bus' of %s", path)
	}

	if s.ChannelID == "" {
		log.Printf("Warning: Eventbus activities require a ChannelID property; defaulting to 'ToUserId' for #{path}")
		s.ChannelID = "ToUserId"
	}
}
