package defs

import (
	"path/filepath"
	"strings"
)

type FieldGroup struct {
	Name       string
	PrettyName string
	Alert      Alert   `json:"alert"`
	Fields     []Field `json:"fields"`
}

func (fieldGroup *FieldGroup) fix(templateInfo *TemplateInfo, path string) {
	name := strings.TrimSuffix(filepath.Base(path), filepath.Ext(path))

	fieldGroup.Alert.fix(templateInfo, path, makePrettyName(name))
	fixFields(fieldGroup.Fields, path)
}
