package defs

import (
	"os"
	"strings"
	"unicode"
)

func makePrettyName(name string) string {
	prettyName := strings.ReplaceAll(strings.Title(strings.ReplaceAll(name, "_", " ")), " ", "")
	if strings.HasSuffix(prettyName, "Id") {
		prettyName = prettyName[:len(prettyName)-2] + "ID"
	}
	return prettyName
}

func variableName(str string) string {
	for i, v := range str {
		return string(unicode.ToLower(v)) + str[i+1:]
	}
	return ""
}

// isDirectory reports whether the named file is a directory.
func isDirectory(name string) bool {
	info, err := os.Stat(name)
	if err != nil {
		return false
	}
	return info.IsDir()
}

func filterValidFields(fields []Field, includeFields, ignoreFields []string) []Field {
	var result []Field
	for _, field := range fields {
		if len(ignoreFields) > 0 {
			found := false
			for _, ignoreField := range ignoreFields {
				found = ignoreField == field.Name
				if found {
					break
				}
			}
			if !found {
				result = append(result, field)
			}
		} else {
			for _, includeField := range includeFields {
				if includeField == field.Name {
					result = append(result, field)
					break
				}
			}
		}
	}
	return result
}

func fixFields(fields []Field, path string) {
	for idx := range fields {
		fields[idx].fix(path, idx)
	}
	for idx := range fields {
		fields[idx].fixAnonymous(fields, path, idx)
	}
}
