package defs

import "log"

type SNSField struct {
	Type             string `json:"type"`
	Name             string `json:"name"`
	PrettyName       string `json:"pretty_name"`
	Optional         bool   `json:"optional"`
	Required         bool   `json:"required"`
	FailValidationIf string `json:"fail_validation_if"`
}

func (f *SNSField) fix(path string, idx int) {
	if f.Name == "" {
		log.Fatalf("No 'name' found in sns_field %d of %s", idx, path)
	}
	if f.Type == "" {
		log.Fatalf("No 'type' found in field %d of %s", idx, path)
	}
	if f.PrettyName == "" {
		f.PrettyName = makePrettyName(f.Name)
	}
	if f.FailValidationIf != "" {
		f.Required = true
	}
}

func (f *SNSField) FailValidationCondition() string {
	if f.FailValidationIf == "" {
		if f.Optional {
			f.FailValidationIf = "== nil"
		} else {
			switch f.Type {
			case "string":
				f.FailValidationIf = `== ""`
			case "bool":
				f.FailValidationIf = "== false"
			default:
				f.FailValidationIf = "== 0"
			}
		}
	}
	return f.FailValidationIf
}

func (f *SNSField) VariableName() string {
	return variableName(f.PrettyName)
}
