package main

import (
	"context"
	"log"

	"github.com/aws/aws-lambda-go/lambda"
)

func main() {
	lambda.StartHandler(Handler{})
}

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct{}

// Invoke allows Handler to implement github.com/aws/aws-lambda-go/lambda.Handler.
func (h Handler) Invoke(ctx context.Context, payload []byte) ([]byte, error) {
	log.Println("dummy handler invoked with payload: ", string(payload))

	return nil, nil
}
