// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2020-10-13 16:33:24.805309 -0700 PDT m=+0.017323309
// Template path: handler_definitions/templates/cmd/event/{name}/main.go.tmpl

package main

import (
	"os"

	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/secrets"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/internal/event/boosts"
	"code.justin.tv/cb/sauron/internal/rollbar"
	"code.justin.tv/cb/sauron/internal/util"
	"github.com/aws/aws-lambda-go/lambda"
	log "github.com/sirupsen/logrus"
)

func main() {
	env := os.Getenv("ENVIRONMENT")
	if env == "" {
		env = "development"
	}

	secretsManager, err := secrets.NewManager()
	if err != nil {
		log.WithError(err).Error("could not create secrets manager: ", err)
		return
	}

	rollbarToken, err := secretsManager.GetSecret(os.Getenv("ROLLBAR_TOKEN_SECRET_NAME"), os.Getenv("ROLLBAR_TOKEN_SECRET_KEY"))
	if err != nil {
		log.Fatal("sauron: could not retrieve rollbar token: ", err)
	}

	rollbar.SetupLogging(rollbarToken, env)

	statsdClient, err := stats.NewClient(os.Getenv("STATSD_HOST"), env)
	if err != nil {
		log.WithError(err).Fatal("failed to initialize statsd client")
		return
	}

	dynamoCredentials := util.GetCredsForLambda()
	dynamoDBClient, err := dynamodb.NewClient(dynamodb.DynamoClientParams{
		ActivityTable:   os.Getenv("DYNAMODB_TABLE_NAME"),
		AlertPrefsTable: os.Getenv("ALERT_PREFERENCES_TABLE_NAME"),
		RateLimitTable:  os.Getenv("RATE_LIMIT_TABLE_NAME"),
		Region:          os.Getenv("AWS_REGION"),
		Statsd:          statsdClient,
		Credentials:     dynamoCredentials,
	})
	if err != nil {
		log.WithError(err).Fatal("failed to initialize dynamodb client")
		return
	}

	pubsubClient, err := pubsub.NewClient(env, os.Getenv("PUBSUB_HOST"))
	if err != nil {
		log.WithError(err).Fatal("failed to initialize pubsub client")
		return
	}

	usersClient, err := users.NewClient(os.Getenv("USERS_SERVICE_HOST"))
	if err != nil {
		log.WithError(err).Fatal("failed to initialize users service client")
		return
	}

	lambda.StartHandler(boosts.Handler{
		DynamoDB: dynamoDBClient,
		Pubsub:   pubsubClient,
		Users:    usersClient,
		Statsd:   statsdClient,
	})
}
