package main

import (
	"code.justin.tv/eventbus/schema/pkg/user_follow_user"
	"fmt"
	"log"

	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/testhelpers"
)

func main() {
	message := &user_follow_user.UserFollowUserCreate {
		FromUserId: "149748365",
		ToUserId: "48276979",
	}

	raw, err := testhelpers.MakePayload(&eventbus.Header{}, message)
	if err != nil {
		log.Fatal(err.Error())
	}

	snsMessage := raw.FakeSNSMessage()
	snsMessage.TopicArn = "arn:aws:sns:us-west-2:859517684765:eventbus_production_UserFollowUserCreate:870c1e47-4d1c-4bd4-84ae-de81e730035d"

	body, err := snsMessage.SQSBody()
	if err != nil {
		log.Fatal(err.Error())
	}

	// prod (careful! this goes to prod)
	// url := "https://sqs.us-west-2.amazonaws.com/989470033077/cb-sauron-production-eventbus"

	// staging
	url := "https://sqs.us-west-2.amazonaws.com/989470033077/cb-sauron-staging-eventbus"

	fmt.Printf(`aws sqs send-message --queue-url "%s" --message-body '%s'`, url, body)
}
