package main

import (
	"code.justin.tv/eventbus/schema/pkg/raid"
	"fmt"
	"log"

	eventbus "code.justin.tv/eventbus/client"
	"code.justin.tv/eventbus/client/testhelpers"
)

func main() {
	message := &raid.RaidUpdate {
		Id: "123",
		FromBroadcasterUserId: "149748365",
		ToBroadcasterUserId: "48276979",
		Status: 1,
		Viewers: 40,
	}

	raw, err := testhelpers.MakePayload(&eventbus.Header{}, message)
	if err != nil {
		log.Fatal(err.Error())
	}

	snsMessage := raw.FakeSNSMessage()
	snsMessage.TopicArn = "arn:aws:sns:us-west-2:859517684765:eventbus-production-RaidUpdate:5a00b5ba-02af-4f2c-9369-4b22eec852fd"

	body, err := snsMessage.SQSBody()
	if err != nil {
		log.Fatal(err.Error())
	}

	// prod (careful! this goes to prod)
	// url := "https://sqs.us-west-2.amazonaws.com/989470033077/cb-sauron-production-eventbus"

	// staging
	url := "https://sqs.us-west-2.amazonaws.com/989470033077/cb-sauron-staging-eventbus"

	fmt.Printf(`aws sqs send-message --queue-url "%s" --message-body '%s'`, url, body)
}
