# Sauron API

Sauron's API is generated by twirp. You can find the service definition [here](https://git.xarth.tv/cb/sauron/blob/master/rpc/sauron/service.proto).

## Table of Contents
1. [GetActivities](#getactivities)
2. [GetAlertPrefs](#getalertprefs)
3. [SetAlertPrefs](#setalertprefs)
4. [GetAlertQueue](#getalertqueue)
5. [SetAlertStatus](#setalertstatus)

## GetActivities
Returns activity for a given channel ID. The cursor is a base64 encoded timestamp string. It is used to allow the caller to limit the time range
of activity to be returned. For example, if you only want activity in the last 3 hours, you can provide a cursor to limit to that range. The cursor
is, as the name suggest, also used for pagination purposes.

Route: `/twirp/code.justin.tv.cb.sauron.Sauron/GetActivities`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `channelID:<string>, cursor:<string>, limit:<int64>`

Response:
```
message GetActivitiesResp {
    repeated Activity activities = 1;
}

message Activity {
    string ID = 1;
    google.protobuf.Timestamp timestamp = 2;
    string type = 3;
    string cursor = 4;

    BitsData bits = 5;
    FollowData follows = 6;
    HostData host = 7;
    RaidData raid = 8;
    SubscriptionData subscription = 9;
    SubscriptionGiftData subscriptionGift = 10;
    string alertStatus = 11;
}
...
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "channelID": "<string>", "cursor": "<string>", "limit": <number> }`

Response:
```
{
    "activities": [
        {
            "ID": "<string>",
            "type": "<string>",
            "timestamp": "<string>",
            "cursor": "<string>",
            ...
        }
        ...
    ]
}
```


## GetAlertPrefs
Returns alert preferences for a given channel ID

Route: `/twirp/code.justin.tv.cb.sauron.Sauron/GetAlertPrefs`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `channelID:<string>`

Response:
```
message GetAlertPrefsResp {
    AlertPrefs alertPrefs = 1;
}

message AlertPrefs {
    string channelID = 1;
    google.protobuf.Timestamp lastModified = 2;
    bool DNDModeEnabled = 3;
    bool hideFollows = 4;
    bool hideRaids = 5;
    bool hideHosts = 6;
    bool hideBits = 7;
    bool hideSubscriptions = 8;
}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "channelID": "<string>" }`

Response:
```
{
    "alertPrefs": {
        "channelID": "<string>",
        "lastModified": "<string>",
        "dndModeEnabled": <bool>,
        "hideFollows": <bool>,
        "hideRaids": <bool>,
        "hideHosts": <bool>,
        "hideBits": <bool>,
        "hideSubscriptions": <bool>
    }
}
```

## SetAlertPrefs
Set the value of an alert preference. This returns the channel's alert preferences with the updated setting.

Route: `/twirp/code.justin.tv.cb.sauron.Sauron/SetAlertPrefs`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `channelID:<string>, key:<string>, val:<bool>`

Response:
```
message SetAlertPrefsResp {
    AlertPrefs alertPrefs = 1;
}

message AlertPrefs {
    string channelID = 1;
    google.protobuf.Timestamp lastModified = 2;
    bool DNDModeEnabled = 3;
    bool hideFollows = 4;
    bool hideRaids = 5;
    bool hideHosts = 6;
    bool hideBits = 7;
    bool hideSubscriptions = 8;
}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "channelID": "<string>", "key": "<string>", "val": <bool> }`

Response:
```
{
    "alertPrefs": {
        "channelID": "<string>",
        "lastModified": "<string>",
        "dndModeEnabled": <bool>,
        "hideFollows": <bool>,
        "hideRaids": <bool>,
        "hideHosts": <bool>,
        "hideBits": <bool>,
        "hideSubscriptions": <bool>
    }
}
```

## GetAlertQueue
Returns all queued alerts for a given channel ID. In this context, an alert is simply an activity with the status of `queued`.
Like the `GetActivities` route, the cursor is a base64 encoded timestamp string.

Route: `/twirp/code.justin.tv.cb.sauron.Sauron/GetAlertQueue`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `channelID:<string>, cursor:<string>, limit:<int64>`

Response:
```
message GetAlertQueueResp {
    repeated Activity alerts = 1;
}

message Activity {
    string ID = 1;
    google.protobuf.Timestamp timestamp = 2;
    string type = 3;
    string cursor = 4;

    BitsData bits = 5;
    FollowData follows = 6;
    HostData host = 7;
    RaidData raid = 8;
    SubscriptionData subscription = 9;
    SubscriptionGiftData subscriptionGift = 10;
    string alertStatus = 11;
}
...
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "channelID": "<string>", "cursor": "<string>", "limit": <number> }`

Response:
```
{
    "alerts": [
        {
            "ID": "<string>",
            "type": "<string>",
            "timestamp": "<string>",
            "cursor": "<string>",
            ...
        }
        ...
    ]
}
```

## SetAlertStatus
Changes the alert status of an activity. This returns the activity with the newly changed alert status.

Route: `/twirp/code.justin.tv.cb.sauron.Sauron/SetAlertStatus`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `channelID:<string>, activityID:<string>, alertStatus:<string>`

Response:
```
message SetAlertStatusResp {
    Activity activity = 1;
}

message Activity {
    string ID = 1;
    google.protobuf.Timestamp timestamp = 2;
    string type = 3;
    string cursor = 4;

    BitsData bits = 5;
    FollowData follows = 6;
    HostData host = 7;
    RaidData raid = 8;
    SubscriptionData subscription = 9;
    SubscriptionGiftData subscriptionGift = 10;
    string alertStatus = 11;
}
...
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "channelID": "<string>", "activityID": "<string>", "alertStatus": <string> }`

Response:
```
{
    "activity": {
            "ID": "<string>",
            "type": "<string>",
            "timestamp": "<string>",
            "cursor": "<string>",
            ...
    }
}
```
