# CI/CD

All build and deployment jobs via Jenkins are defined in [`jenkins.groovy`](../jenkins.groovy).

## Build

The AWS Lambda functions described in [Architecture](./architecture.md#lambda) execute distinct Go binaries.

Upon a GitHub Enterprise push event, a webhook queues a Jenkins multijob that kicks off the build process for each Lambda executable.

Each executable is built in a distinct Jenkins build job. The artifact is then uploaded to S3.

## Deployment

Deploying sauron is done through jenkins and [clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/sauron).

1. Create a new branch for a feature in [cb/sauron](https://git.xarth.tv/cb/sauron).
2. Create a pull request for your branch. Ask in the slack channel #dashboard-feedback for a review.
3. Deploy your branch to staging using clean-deploy. Errors are logged to [Rollbar](https://rollbar.com/Twitch/CB_Sauron/items/) if you have access. They are also posted to #cplat-backend-deploys in Slack.
4. After your PR is approved, merge your branch to master and deploy, again using clean-deploy. Check Rollbar for errors.

### Environment

Only the `master` branch is allowed to be deployed to **production** (see [`deploy.json`](../deploy.json)).

## Rolling Back

You can use clean-deploy to rollback your changes if anything breaks. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze sauron from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze sauron` button in the top right corner.
