# Sauron Design and Internals

## Table of Contents
1. [What Sauron Does](#what-sauron-does)
2. [How Sauron Works](#how-sauron-works)
3. [Architecture](#architecture)
4. [Project Organization](#project-organization)

## What Sauron Does
[Activity Feed Product Doc](https://docs.google.com/document/d/14um6lhZSoUqiRZ885ieaJvO0ZPW77XXlJJUqU7nhB78) | [Spotlight Alerts Product Doc](https://docs.google.com/document/d/1w7cIt8YdvZmQ6M_SIuQKK_uZDNokIQO5BiH3_gXL_CM) | [Spotlight Alerts Tech Spec](https://docs.google.com/document/d/1RlgcfQGImNGGwjuwm571CtIH6j116briUf5PDbR5I9Y)

Sauron collects activity across twitch, categorizes them, and aggregates them into a dynamo table. "Activity" refers to any action that a viewer can take that
affects a broadcasters stream, like following or subscribing. It does not include anything that a broadcaster does to their own stream, like adding a moderator
or running an ad (if you need that data, see [watchers](https://git.xarth.tv/cb/watchers)). This data is shown in the live dashboard, on the
activity feed component.

In addition, sauron adds a field to activity called "Alert Status". Each type of activity can optionally be displayed as a stream alert in the Spotlight
broadcasting software. These alert statuses are used by clients to determine if an alert should be shown or skipped, etc. This field is part of activity
because a broadcaster can monitor and manage alerts from the activity feed component, which tightly couples activity and alerts. When alerts are referred
to in Sauron, this refers to the alert status field. Every alert is an activity, but not every activity needs to be an alert.

Sauron also publishes messages about new activity and alert status changes. These messages are routed using pubsub, and can be used by clients to get
real time updates to a channels activity without polling.

## How Sauron Works
Sauron collects activity by subscribing to SNS topics that are managed by various teams at Twitch. Each subscription is connected to an SQS queue,
which is tied to a lambda specific to that event. The lambda reads messages from the queue, writes them to a dynamodb table and publishes
the new activity to a pubsub topic.

At this time, the alert status is also added to the activity and that status is also published to a separate alerts status topic, if required.
This step only happens if the broadcaster has alerts turned on, and they're enabled for this specific type of activity.

Sauron provides a twirp generated API for retrieving channel activity, as well as getting/setting alerts information. These endpoints, in conjunction with
pubsub messages, allow clients to track historical activity and keep up to date with new events.

## Architecture

[LucidChart](https://www.lucidchart.com/invitations/accept/e9fdcff0-836c-48a5-9a30-5f4eec570dc9)

![Sauron Architecture](./images/sauron_architecture.png)

## Project Organization
`activity`: Type and error definitions needed externally for activity.

`cmd`: The entry points for each lambda function and the API server.

`rpc`: Service definition.

`scripts`: Build and deploy scripts.

`terraform`: Infrastructure management.

`client`: A custom client for using the `GetActivities` lambda. This should not be used; instead use the twirp generated client.

`internal/activity`: Code for retrieving channel activity, used by the `GetActivities` lambda.

`internal/alerts`: Code for setting and getting alert statuses.

`internal/clients`: Contains all the clients for sauron's dependencies. These are wrapped to make it easier to unit test.

`internal/event`: All the handlers for activity lambdas.

`internal/errors`: Error types for internal use

`internal/sauronserver`: The twirp server for sauron's API.
