# Pubsub

Each activity is also sent to the Chat team's [PubSub system](https://git.xarth.tv/chat/pubsub-edge) to be published via WebSocket to any listening client in a publish-subscribe pattern.

See [PubSub hosts](https://git.xarth.tv/chat/pubsub-edge#hosts) for the edge hosts to connect via WebSocket.

See the [PubSub](./pubsub.md) document for details regarding the topic, payload signature, and integration testing.

## Working with Chat's PubSub System

PubSub messages are dispatched under the root topic message, `dashboard-activity-feed` and scoped to the specific channel ID.

An example topic is: `dashboard-activity-feed.123456`.

NOTE: In staging, all topics are prepended with `pubsubtest.`, such as `pubsubtest.dashboard-activity-feed.123456`.

The [payload](../activity/pubsub/schema.go#L14) is distributed as JSON and formatted with default values, `id`, `timestamp`, and `type`.

Note:

* `id` is a unique UUID associated with the specific activity/event.

* `type` is mapped to a specific set of [activity type strings](../activity/type.go#L3). Different keys and values are included in the payload depending on the [activity type](../activity/pubsub/schema.go#L17).

## Sample PubSub Response

```json
{
  "type": "MESSAGE",
  "data": {
    "topic": "dashboard-activity-feed.123456",
    "message": "{\"id\":\"some-event-id\",\"timestamp\":\"2018-11-15T21:38:56.511492103Z\",\"type\":\"bits_usage\",\"bits_amount\":100,\"bits_anonymous\":false,\"bits_user\":{\"display_name\":\"some-display-name\",\"login\":\"some-login\",\"id\":\"some-channel-id\"}}"
  }
}
```

### Message

From the JSON response, the `data.message` JSON string is deserialized to:

```json
{
  "id": "some-event-id",
  "timestamp": "2018-11-15T21:38:56.511492103Z",
  "type": "bits_usage",
  "bits_amount": 100,
  "bits_anonymous": false,
  "bits_user": {
    "display_name": "some-display-name",
    "login": "some-login",
    "id": "some-channel-id"
  }
}
```

## Validating Integration

To verify that a given Lambda handler is sending messages to the PubSub system, follow these simplified steps:

1. Use [`wscat`](./setup.md#websocket-cat) to open a WebSocket connection to the PubSub edge host:

    ```sh
    $ wscat --connect wss://enter.pubsub.host.here
    connected (press CTRL+C to quit)
    > {"type": "PING"}
    < {"type": "PONG"}
    ```

    Choose the appropriate host from the list of [PubSub hosts](https://git.xarth.tv/chat/pubsub-edge#hosts), depending on the environment and host of the [PubSub Broker](https://git.xarth.tv/twitch/docs/blob/master/pubsub/pubsub-broker.md) that is configured for the Lambda handler.

2. Listen to a specific Twitch channel's Dashboard Activity Feed topic:

    ```sh
    connected (press CTRL+C to quit)
    > {
        "type": "LISTEN",
        "nonce": "anything can go here",
        "data": {
          "topics": ["dashboard-activity-feed.123456"],
          "auth_token": "not required for this topic"
        }
      }

    < {"type": "RESPONSE", "error": "", "nonce": "anything can go here"}

    < {"type": "MESSAGE", "data": {"topic": "dashboard-activity-feed.123456", "message": "{\"id\":\"9f02dda9-6a5d-4d97-8fec-78a701a4c7ee\",\"timestamp\":\"2019-02-06T22:47:09.651306308Z\",\"type\":\"follow\",\"follower\":{\"id\":\"1\",\"login\":\"kappa\",\"display_name\":\"Kappa\"}}"}}
    ```

See the [PubSub Edge](https://git.xarth.tv/twitch/docs/blob/master/pubsub/pubsub-edge.md#pubsub-edge) documentation for detailed instructions.
