# Sauron Runbook

This describes the different components of Sauron and how they operate.

[twitch-cb-aws account](https://twitch-cb-aws.signin.aws.amazon.com/console)

[Pagerduty](https://twitchoncall.pagerduty.com/services/PH7QEWY)

[Service Catalog](https://servicecatalog.internal.justin.tv/services/532)

[Github](https://git.xarth.tv/cb/sauron)

[clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/sauron)

[Dashboard](https://grafana.xarth.tv/d/JkVhfvRZk/sauron)

## Table of Contents
1. [Deploying and Rollbacks](#deploying-and-rollbacks)
2. [Monitoring and Errors](#monitoring-and-errors)
3. [Pagerduty](#pagerduty)
4. [Infrastructure](#infrastructure)
    1. [Terraform](#terraform)
    2. [Elastic Beanstalk](#elastic-beanstalk)
    3. [DynamoDB](#dynamodb)
    4. [Lambda](#lambda)
5. [Past Alarms](#past-alarms)

### Deploying and Rollbacks
See the deployment[docs](/docs/deployment.md) for help with deploying and rolling back.

### Monitoring and Errors
Errors are logged to [rollbar](https://rollbar.com/Twitch/CB_Sauron/items/).
There is a Grafana dashboard [here](https://grafana.internal.justin.tv/d/JkVhfvRZk/cb-sauron).
Lambdas can can also be monitored from the AWS console:

1. [Production/Staging](https://us-west-2.console.aws.amazon.com/lambda/home?region=us-west-2#/functions)

DynamoDB can also be monitored from the AWS console, in the Metrics tab:

1. [Production/Staging](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Sauron)

Note that you need to request access to Rollbar and to the AWS account where the application lives (but grafana should be accessible). For access, ask in #dashboard-feedback on slack
or ping David Horn.

### Pagerduty
[Pagerduty](https://twitchoncall.pagerduty.com/services/PH7QEWY)
Pagerduty is integrated with both Cloudwatch and rollbar. Pages are sent based on error rates and application health. See [alarms](/docs/alarms.md) for details.

## Infrastructure

### Terraform
Infrastructure configuration is done using terraform. All these files live in the git repo, in the `terraform` folder. Changes should be applied to both staging and production, and committed to the repo using a pull request. If you need assistance with terraform, ask in #dashboard-feedback on slack.

### Elastic Beanstalk
The Sauron API runs in an Elastic Beanstalk environment, inside the twitch-cb-aws account.
1. [Production](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-sauron-production&environmentId=e-pxvybmakfn)
2. [Staging](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-sauron-staging&environmentId=e-rxvntxjsh9)

### DynamoDB
Sauron stores channel activity and alert information in dynamo tables. It mainly follows a single table dynamo design, however broadcaster alert preferences are stored in a separate dynamo table.

1. Channel activity and alert statuses:
    - [Production](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Sauron;selected=sauron-production-channel_activity;tab=overview)
    - [Staging](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Sauron;selected=sauron-staging-channel_activity;tab=overview)

2. Alert Preferences:
    - [Production](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Sauron;selected=sauron-production-alert_preferences;tab=overview)
    - [Staging](https://us-west-2.console.aws.amazon.com/dynamodb/home?region=us-west-2#tables:group=Sauron;selected=sauron-staging-alert_preferences;tab=overview)

### Lambda
All event processing is done using lambdas subscribed to SNS topics for each event.
1. [Production](https://us-west-2.console.aws.amazon.com/lambda/home?region=us-west-2#/functions?f0=a3c%3D%3AY2Itc2F1cm9uLXByb2R1Y3Rpb24%3D)
2. [Staging](https://us-west-2.console.aws.amazon.com/lambda/home?region=us-west-2#/functions?f0=a3c%3D%3AY2Itc2F1cm9uLXN0YWdpbmc%3D)

### Past Alarms
See [alarms](/docs/alarms.md) for details.
