# Setup

[Homebrew](https://docs.brew.sh/Installation) is required to install necessary tools.

Once you have homebrew and go installed, project dependencies can be installed by running `make setup`.
If there are any errors running this command, reach out to #dashboard-feedback on slack.

The rest of this doc describes how to set up optional tools for additional testing.

## Installing Go

```sh
brew install go
```

Add `/usr/local/go/bin` to the `PATH` environment variable:

```sh
export PATH=$PATH:/usr/local/go/bin
```

See https://golang.org/doc/install#install to troubleshoot.

## AWS

Request for an IAM user to Creator Business' AWS account.

Add the credentials to your local `~/.aws/credentials`.

https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-files.html

### AWS CLI

Use the [AWS CLI](https://aws.amazon.com/cli/) to connect to AWS.

```sh
brew install awscli
```

### AWS Serverless Application Model CLI

Use the [AWS SAM CLI](https://github.com/awslabs/aws-sam-cli) to invoke Lambda handlers locally.

```sh
brew tap aws/tap
brew install aws-sam-cli
```

https://docs.aws.amazon.com/serverless-application-model/latest/developerguide/serverless-sam-cli-install-mac.html#serverless-sam-cli-install-mac-homebrew

## Terraform

AWS infrastructure is entirely managed via [Terraform](https://www.terraform.io/docs/index.html).

https://learn.hashicorp.com/terraform/getting-started/install.html

See Terraform configuration files under [`terraform/`](../terraform).

Note that you need credentials to the `twitch-cb-aws` account in order to apply terraform locally.

### Terraform Landscape (optional)

[Terraform Landscape](https://github.com/coinbase/terraform-landscape) "prettifies" the output of `terraform plan`.

Install:

```sh
brew install terraform_landscape
```

Usage:

```sh
terraform plan ... | landscape
```

## WebSocket Cat

Use [`wscat`](https://github.com/websockets/wscat) to verify that messages are sent through the Chat team's [PubSub](https://git.xarth.tv/chat/pubsub-edge) system to any WebSocket listeners.

```sh
brew install node
npm install -g wscat
```

https://github.com/websockets/wscat#installation
