# Manual Testing

This document covers effective ways to manually test certain parts of Sauron. It's a work in progress.


### Manually Testing EventBus messages

It may be common to want to create a test raid or follow event, but you may run into issues like the Follow rate-limitting or difficulty setting up a large enough raid for testing (always test with at least 2 raiders!). Luckily, there is a programmatic approach based on [this EventBus guide](https://git.xarth.tv/pages/eventbus/docs/subscribers/testing/#generate-sqs-payloads)

To leverage this, we added files for creating events for [Raids](https://git.xarth.tv/cb/sauron/blob/master/cmd/test/eventbus_raids/main.go) and [Follows](https://git.xarth.tv/cb/sauron/blob/master/cmd/test/eventbus_follows/main.go). To use them simply change the data at the top of the respective file and then do `go run cmd/test/eventbus_raids/main.go` or `go run cmd/test/eventbus_follows/main.go`. This will output a command, such as:
```
aws sqs send-message --queue-url "https://sqs.us-west-2.amazonaws.com/989470033077/cb-sauron-staging-eventbus" --message-body '{"MessageId":"8c99ffd6-ea95-4bd8-9c44-2b6f0879d63d","Type":"Notification","TopicArn":"arn:aws:sns:us-west-2:859517684765:eventbus_production_UserFollowUserCreate:870c1e47-4d1c-4bd4-84ae-de81e730035d","Timestamp":"2021-04-21T23:55:25.119385Z","Message":"AQA1ChBnBM739K5Kg7TiJqEFDSduEhRVc2VyRm9sbG93VXNlckNyZWF0ZRoLCO32goQGEMDh8DgKCTE0OTc0ODM2NRIINDgyNzY5Nzk"}'
```

Authenticate with the `twitch-cb-aws` account (Admin role) and then run the above command. If you do not have Admin rights for this account, notify a Sauron maintainer and we will help you with this test.

> NOTE: Be aware that running this WILL create an activity event for staging. Moreover, if the url is set for production in the code, it will create the event in production. The event is only sent to Sauron, but all downstream dependencies, such as the activity feed, will get this event (which is what you may want after all).


### Manually Testing SNS Messages

SNS messages can be created and put into our SQS queues directly through the AWS console as described [here](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-using-send-messages.html). 

The best way to do this is to go to the STAGING SQS queue and under "Send and receive messages", find the "Receive messages" panel and click "Poll for messages". If any messages are received by that queue, click on the message and copy the ENTIRE messages Body. For example:

```
{
  "Type": "Notification",
  "MessageId": "abc",
  "TopicArn": "arn:aws:sns:us-west-2:522398581884:subscription_notice_production",
  "Message": "{\"benefit_end_month\":0,\"channel_id\":\"456\",\"cumulative_tenure_months\":1,\"custom_message\":\"\",\"is_extension_subscription\":false,\"streak_tenure_months_shared\":false,\"streak_tenure_months\":0,\"sub_plan\":\"Prime\",\"tier\":\"1000\",\"timestamp\":\"2021-05-17T21:55:18.419879709Z\",\"user_id\":\"123\",\"multi_month_duration\":0,\"multi_month_tenure\":0}",
  "Timestamp": "2021-05-17T21:55:18.425Z",
  "SignatureVersion": "1",
  "Signature": "something",
  "SigningCertURL": "https://sns.us-west-2.amazonaws.com/something",
  "UnsubscribeURL": "https://sns.us-west-2.amazonaws.com/somethingelse",
  "MessageAttributes": {
    "origin": {
      "Type": "String",
      "Value": "revenue/subscriptions"
    },
    "event": {
      "Type": "String",
      "Value": "Prime"
    }
  }
}
```

Modify the fields you want from "Message" (***be sure to at least change the corresponding channel_id and user_id fields, especially in production, or the event might go to someone else! I recommend using your own staff account for channel_id***). When done, paste the ENTIRE JSON (not just the message) into "Message body" under the "Send message" panel, and click send. If there are errors with this message, they will appear in CloudWatch for this event type (ie subscriptions).

See "Manually checking results sent to Staging GQL" below for tips on verifying the messages sent to staging.

> NOTE: Make sure you are sending only to staging SQS queues unless you REALLY know what you're doing!!


### Manually verifying on Sauron staging, via staging GQL

You can query data fetched from staging Sauron by querying against GQL's staging url, https://dev-graphql.twitch.a2z.com/master/gql . I recommend using [GraphQL Playground](https://github.com/graphql/graphql-playground) with that staging GQL url and querying for the current user's activity feed. You can use the following query:

```
fragment dashboardActivityFeedNode on DashboardActivityFeedActivity {
  alertStatus
  id
  timestamp

  ... on DashboardActivityFeedActivityBitsUsage {
    amount
    isAnonymous
    user {
      id
      login
      displayName
    }
  }
  
  ... on DashboardActivityFeedActivityBoostStart {
    goalProgress
    goalTarget
    quantity
    purchaser {
      id
      login
      displayName
    }
  }
  
  ... on DashboardActivityFeedActivityBoostComplete {
    goalProgress
    goalTarget
    quantity
    purchaser {
      id
      login
      displayName
    }
  }

  ... on DashboardActivityFeedActivityCopoGoalEnd {
    goalID
    goalTitle
    goalAmount
    goalStatus
    goalType
    pointsContributed
    pointsName
  }
  
  ... on DashboardActivityFeedActivityCommunityPointsReward {
    redeemingUser {
      id
      login
      displayName
    }
    redemption {
      id
    }
    title
    userInput
  }

  ... on DashboardActivityFeedActivityCommunitySubscriptionGifting {
    isAnonymous
    gifter {
      id
      login
      displayName
    }
    giftQuantity
    tier
  }

  ... on DashboardActivityFeedActivityFollowing {
    follower {
      id
      login
      displayName
    }
  }

  ... on DashboardActivityFeedActivityHosting {
    id
    host {
      id
      login
      displayName
    }
    hostingViewerCount: viewerCount
    timestamp
  }

  ... on DashboardActivityFeedActivityAutoHosting {
    id
    host {
      id
      login
      displayName
    }
    autoHostViewerCount: viewerCount
    timestamp
  }

  ... on DashboardActivityFeedActivityIndividualSubscriptionGifting {
    isAnonymous
    giftedMonths
    gifter {
      id
      login
      displayName
    }
    recipient {
      id
      login
      displayName
    }
    tier
  }

  ... on DashboardActivityFeedActivityPrimeSubscribing {
    id
    subscriber {
      id
      login
      displayName
    }
    timestamp
  }

  ... on DashboardActivityFeedActivityRaiding {
    id
    raider {
      id
      login
      displayName
    }
    raidingViewerCount: viewerCount
    timestamp
  }

  ... on DashboardActivityFeedActivitySubscribing {
    id
    subscriber {
      id
      login
      displayName
    }
    tier
    timestamp
    multiMonthDuration
    multiMonthTenure
  }

  
  ... on DashboardActivityFeedActivityCelebrationPurchaseEvent {
    purchasingUser {
      id
      login
      displayName
    }
    intensity
    effect
  }

  ... on DashboardActivityFeedActivityHypeTrainEvent {
    hypeTrainID
    type
    completedLevel
    totalSubsCount
    totalBitsAmount
  }
}


query ($channelLogin: String!, $limit: Int!) {
  user(login: $channelLogin) {
    id
    dashboardActivityFeedActivities(first: $limit) {
      edges {
        cursor
        node {
          ...dashboardActivityFeedNode
        }
      }
    }
  }
}
```

Under `Query Variables`, put the proper values (replace `YOURCHANNEL` with your channel's login):
```
{
  "channelLogin": "YOURCHANNEL",
  "limit": 20
}
```

And the following under HTTP Headers, replacing `YOUR_AUTH_TOKEN` with an auth token from Twilight, which should show up as the `auth_token` cookie in twitch.tv:
```
{
  "Authorization": "OAuth YOUR_AUTH_TOKEN",
  "Client-ID": "kimne78kx3ncx6brgo4mv6wki5h1ko"
}
```
