package dynamodb

import (
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
	"github.com/pkg/errors"
)

// DynamoClientParams holds params need to instantiate a new Dynamo client
type DynamoClientParams struct {
	ActivityTable   string
	AlertPrefsTable string
	RateLimitTable  string
	Region          string
	Statsd          stats.StatSender
	Credentials     *credentials.Credentials
}

// Client wraps the dynamodb client.
type Client struct {
	activityTable   string
	alertPrefsTable string
	rateLimitTable  string
	statsd          stats.StatSender
	dynamoDB        dynamodbiface.DynamoDBAPI
}

// NewClient creates a new dynamodb client for the given table and region.
func NewClient(params DynamoClientParams) (*Client, error) {
	// Dynamo DB setup
	sess, err := session.NewSession(&aws.Config{
		Credentials: params.Credentials,
		MaxRetries:  aws.Int(3),
		Region:      aws.String(params.Region),
	})

	if err != nil {
		return nil, errors.Wrap(err, "dynamodb: failed to initialize dynamo db client")
	}

	return &Client{
		activityTable:   params.ActivityTable,
		alertPrefsTable: params.AlertPrefsTable,
		rateLimitTable:  params.RateLimitTable,
		statsd:          params.Statsd,
		dynamoDB:        dynamodb.New(sess),
	}, nil
}
