// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-03-15 11:26:13.491343 -0700 PDT m=+0.026216258
// Template path: handler_definitions/templates/internal/clients/dynamodb/models.go.tmpl

package dynamodb

import (
	"time"

	"code.justin.tv/cb/sauron/types"
)

// AlertStatus indicates the current alert status of the activity
type AlertStatus string

// constants for the allowable alert statuses
const (
	AlertStatusQueued   AlertStatus = "queued"
	AlertStatusPlaying  AlertStatus = "playing"
	AlertStatusPlayed   AlertStatus = "played"
	AlertStatusSkipped  AlertStatus = "skipped"
	AlertStatusRejected AlertStatus = "rejected"
	AlertStatusFailed   AlertStatus = "failed"
	AlertStatusOffline  AlertStatus = "offline"
	AlertStatusPurged   AlertStatus = "purged"
)

// Activity is what is put into DynamoDB in a flat schema.
type Activity struct {
	ChannelID   string    `dynamodbav:"channel_id"`
	Timestamp   time.Time `dynamodbav:"timestamp"`
	ID          string    `dynamodbav:"id"`
	Type        string    `dynamodbav:"type"`
	ExpiresUnix int64     `dynamodbav:"expires"`

	// BitsUsage
	BitsAmount    *int64  `dynamodbav:"bits_amount,omitempty"`
	BitsAnonymous *bool   `dynamodbav:"bits_anonymous,omitempty"`
	BitsUserID    *string `dynamodbav:"bits_user_id,omitempty"`

	// Follow
	FollowerID *string `dynamodbav:"follower_id,omitempty"`

	// Hosting
	HostID             *string `dynamodbav:"host_id,omitempty"`
	HostingViewerCount *int    `dynamodbav:"hosting_viewer_count,omitempty"`

	// Raiding
	RaiderID           *string `dynamodbav:"raider_id,omitempty"`
	RaidingViewerCount *int32  `dynamodbav:"raiding_viewer_count,omitempty"`
	Status             *int32  `dynamodbav:"status,omitempty"`

	// Subscription
	SubscriberID                       *string          `dynamodbav:"subscriber_id,omitempty"`
	SubscriptionTier                   *string          `dynamodbav:"subscription_tier,omitempty"`
	SubscriptionCumulativeTenureMonths *int             `dynamodbav:"subscription_cumulative_tenure_months,omitempty"`
	SubscriptionCustomMessageFragments []types.Fragment `dynamodbav:"subscription_custom_message_fragments,omitempty"`
	SubscriptionCustomMessageText      *string          `dynamodbav:"subscription_custom_message_text,omitempty"`
	SubscriptionMultiMonthDuration     *int             `dynamodbav:"subscription_multi_month_duration,omitempty"`
	SubscriptionMultiMonthTenure       *int             `dynamodbav:"subscription_multi_month_tenure,omitempty"`

	// SubscriptionGift
	SubscriptionGifterID        *string `dynamodbav:"subscription_gifter_id,omitempty"`
	SubscriptionGiftAnonymous   *bool   `dynamodbav:"subscription_gift_anonymous,omitempty"`
	SubscriptionGiftQuantity    *int    `dynamodbav:"subscription_gift_quantity,omitempty"`
	SubscriptionGiftRecipientID *string `dynamodbav:"subscription_gift_recipient_id,omitempty"`
	SubscriptionGiftTier        *string `dynamodbav:"subscription_gift_tier,omitempty"`
	SubscriptionGiftMonthAmount *int    `dynamodbav:"subscription_gift_month_amount,omitempty"`

	// Boost
	BoostOrderGoalProgress *int    `dynamodbav:"boost_order_goal_progress,omitempty"`
	BoostOrderGoalTarget   *int    `dynamodbav:"boost_order_goal_target,omitempty"`
	BoostOrderQuantity     *int    `dynamodbav:"boost_order_quantity,omitempty"`
	BoostOrderPurchaserID  *string `dynamodbav:"boost_order_purchaser_id,omitempty"`

	// CelebrationPurchase
	CelebrationPurchasingUserID *string `dynamodbav:"celebration_purchasing_user_id,omitempty"`
	Intensity                   *string `dynamodbav:"intensity,omitempty"`
	Effect                      *string `dynamodbav:"effect,omitempty"`

	// ChannelPointsCustomRewardRedemption
	ChannelPointsRedemptionID    *string `dynamodbav:"channel_points_redemption_id,omitempty"`
	ChannelPointsRedeemingUserID *string `dynamodbav:"channel_points_redeeming_user_id,omitempty"`
	ChannelPointsRewardID        *string `dynamodbav:"channel_points_reward_id,omitempty"`
	ChannelPointsRewardTitle     *string `dynamodbav:"channel_points_reward_title,omitempty"`
	ChannelPointsUserInput       *string `dynamodbav:"channel_points_user_input,omitempty"`

	// ChannelPointsGoalUpdate
	ChannelPointsGoalID            *string `dynamodbav:"channel_points_goal_id,omitempty"`
	ChannelPointsGoalTitle         *string `dynamodbav:"channel_points_goal_title,omitempty"`
	ChannelPointsPointsContributed *int    `dynamodbav:"channel_points_points_contributed,omitempty"`
	ChannelPointsGoalAmount        *int    `dynamodbav:"channel_points_goal_amount,omitempty"`
	ChannelPointsGoalStatus        *string `dynamodbav:"channel_points_goal_status,omitempty"`
	ChannelPointsGoalType          *string `dynamodbav:"channel_points_goal_type,omitempty"`
	ChannelPointsName              *string `dynamodbav:"channel_points_name,omitempty"`

	// DropClaimWindowOpen
	DropName          *string `dynamodbav:"drop_name,omitempty"`
	DropInstanceID    *string `dynamodbav:"drop_instance_id,omitempty"`
	DropQuestName     *string `dynamodbav:"quest_name,omitempty"`
	DropClaimDuration *int32  `dynamodbav:"claim_duration,omitempty"`

	// HypeTrain
	HypeTrainID             *string `dynamodbav:"hype_train_id,omitempty"`
	HypeTrainEventType      *string `dynamodbav:"hype_train_event_type,omitempty"`
	HypeTrainCompletedLevel *int    `dynamodbav:"hype_train_completed_level,omitempty"`
	HypeTrainTotalSubs      *int    `dynamodbav:"hype_train_total_subs,omitempty"`
	HypeTrainTotalBits      *int    `dynamodbav:"hype_train_total_bits,omitempty"`

	// Spotlight alert status
	AlertStatus *AlertStatus `dynamodbav:"alert_status,omitempty"`
}

// AlertPreferences contains the spotlight alert settings for a user
type AlertPreferences struct {
	ChannelID             string     `dynamodbav:"channel_id"`
	LastModified          *time.Time `dynamodbav:"last_modified"`
	DNDModeEnabled        bool       `dynamodbav:"dnd_mode_enabled"`
	HideFollows           bool       `dynamodbav:"hide_follows"`
	HideRaids             bool       `dynamodbav:"hide_raids"`
	HideHosts             bool       `dynamodbav:"hide_hosts"`
	HideBits              bool       `dynamodbav:"hide_bits"`
	HideSubscriptions     bool       `dynamodbav:"hide_subscriptions"`
	HideGiftSubscriptions bool       `dynamodbav:"hide_gift_subscriptions"`
}

// RateLimit is the schema for the rate limit dynamo table
type RateLimit struct {
	Key         string `dynamodbav:"key"`
	Timestamp   string `dynamodbav:"timestamp"`
	ExpiresUnix int64  `dynamodbav:"expires"`

	Type      string `dynamodbav:"type"`
	ChannelID string `dynamodbav:"channel_id"`
	ActorID   string `dynamodbav:"actor_id"`
}

// BitsUsage is the activity of when a user spends Bits via Cheering on a channel.
type BitsUsage struct {
	ID          string
	Timestamp   time.Time
	Amount      int64
	Anonymous   bool
	UserID      string
	AlertStatus AlertStatus
}

// Follow is the activity of when a user begins following a channel.
type Follow struct {
	ID          string
	Timestamp   time.Time
	FollowerID  string
	AlertStatus AlertStatus
}

// AutoHostStart is the activity of when a channel gets autohosted.
type AutoHostStart struct {
	ID          string
	Timestamp   time.Time
	HostID      string
	ViewerCount *int
	AlertStatus AlertStatus
}

// HostStart is the activity of when a channel begins hosting another channel.
type HostStart struct {
	ID          string
	Timestamp   time.Time
	HostID      string
	ViewerCount *int
	AlertStatus AlertStatus
}

// Raiding is the activity of when a raid status has updated.
type Raiding struct {
	ID          string
	Timestamp   time.Time
	RaiderID    string
	ViewerCount int32
	Status      int32
	AlertStatus AlertStatus
}

// PrimeResubscriptionSharing is the activity of when a subscriber shares a resubscription (via Twitch Prime) notice in chat.
type PrimeResubscriptionSharing struct {
	ID                     string
	Timestamp              time.Time
	SubscriberID           string
	CumulativeTenureMonths int
	CustomMessageFragments []types.Fragment
	CustomMessageText      string
	MultiMonthDuration     int
	MultiMonthTenure       int
	AlertStatus            AlertStatus
}

// PrimeSubscription is the activity of when a user subscribes for the first-time to a channel via Twitch Prime.
type PrimeSubscription struct {
	ID           string
	Timestamp    time.Time
	SubscriberID string
	AlertStatus  AlertStatus
}

// ResubscriptionSharing is the activity of when a subscriber chooses to share a resubscription notice in chat.
type ResubscriptionSharing struct {
	ID                     string
	Timestamp              time.Time
	SubscriberID           string
	Tier                   string
	CumulativeTenureMonths int
	CustomMessageFragments []types.Fragment
	CustomMessageText      string
	MultiMonthDuration     int
	MultiMonthTenure       int
	AlertStatus            AlertStatus
}

// Subscription is the activity of when a user subscribes for the first-time to a channel via paid option.
type Subscription struct {
	ID                 string
	Timestamp          time.Time
	SubscriberID       string
	Tier               string
	MultiMonthDuration int
	MultiMonthTenure   int
	AlertStatus        AlertStatus
}

// SubscriptionGiftingIndividual is the activity of when a user gifts a single subscription to another user for a channel.
type SubscriptionGiftingIndividual struct {
	ID          string
	Timestamp   time.Time
	GifterID    string
	Anonymous   bool
	RecipientID string
	Tier        string
	MonthAmount int
	AlertStatus AlertStatus
}

// SubscriptionGiftingCommunity is the activity of when a user gifts multiple subscriptions to other users for a specific channel.
type SubscriptionGiftingCommunity struct {
	ID           string
	Timestamp    time.Time
	GifterID     string
	Anonymous    bool
	GiftQuantity int
	Tier         string
	MonthAmount  int
	AlertStatus  AlertStatus
}

// BoostStart is the activity of when a channel starts getting boosted.
type BoostStart struct {
	ID                     string
	Timestamp              time.Time
	BoostOrderGoalProgress int
	BoostOrderGoalTarget   int
	BoostOrderQuantity     int
	BoostOrderPurchaserID  *string
}

// BoostComplete is the activity of when a channel ends getting boosted because goal target has been reached.
type BoostComplete struct {
	ID                     string
	Timestamp              time.Time
	BoostOrderGoalProgress int
	BoostOrderGoalTarget   int
	BoostOrderQuantity     int
	BoostOrderPurchaserID  *string
}

// CelebrationPurchase is the activity of when a user has purchased a celebration on a channel.
type CelebrationPurchase struct {
	ID                          string
	Timestamp                   time.Time
	CelebrationPurchasingUserID string
	Intensity                   string
	Effect                      string
}

// ChannelPointsCustomRewardRedemption is the activity of when a user has redeemed a custom Channel Points reward for a channel.
type ChannelPointsCustomRewardRedemption struct {
	ID              string
	Timestamp       time.Time
	RedemptionID    string
	RedeemingUserID string
	RewardID        string
	RewardTitle     string
	UserInput       *string
}

// CopoGoalEnded is the activity of when a community challenge ends.
type CopoGoalEnded struct {
	ID                             string
	Timestamp                      time.Time
	ChannelPointsGoalID            string
	ChannelPointsGoalTitle         string
	ChannelPointsPointsContributed int
	ChannelPointsGoalAmount        int
	ChannelPointsGoalStatus        string
	ChannelPointsGoalType          string
	ChannelPointsName              string
}

// DropClaimWindowOpen is the activity of when a channel has completed a DropQuest and viewers are now able to claim the drop.
type DropClaimWindowOpen struct {
	ID                string
	Timestamp         time.Time
	DropName          string
	DropInstanceID    string
	DropQuestName     string
	DropClaimDuration int32
}

// HypeTrain is the activity of when a hype train is activated.
type HypeTrain struct {
	ID                      string
	Timestamp               time.Time
	HypeTrainID             string
	HypeTrainEventType      string
	HypeTrainCompletedLevel *int
	HypeTrainTotalSubs      *int
	HypeTrainTotalBits      *int
}
