// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-03-15 11:26:13.493555 -0700 PDT m=+0.028428679
// Template path: handler_definitions/templates/internal/clients/pubsub/models.go.tmpl

package pubsub

import (
	"time"

	"code.justin.tv/cb/sauron/types"
)

// Alert contains information about alert changes. It also contains arbitrary data about an alert in case extra data is needed.
type Alert struct {
	ActivityID   string      `json:"activity_id"`
	ActivityType string      `json:"activity_type"`
	AlertStatus  string      `json:"alert_status"`
	AlertData    interface{} `json:"alert_data"`
	Type         string      `json:"type"` // this field is required by twilight interfaces
}

// BitsUsage is the activity of when a user spends Bits via Cheering on a channel.
type BitsUsage struct {
	ID        string      `json:"id"`
	Timestamp time.Time   `json:"timestamp"`
	Amount    int64       `json:"bits_amount"`
	Anonymous bool        `json:"bits_anonymous"`
	User      *types.User `json:"bits_user"` // nil if BitsAnonymous
}

// Follow is the activity of when a user begins following a channel.
type Follow struct {
	ID        string     `json:"id"`
	Timestamp time.Time  `json:"timestamp"`
	Follower  types.User `json:"follower"`
}

// AutoHostStart is the activity of when a channel gets autohosted.
type AutoHostStart struct {
	ID          string     `json:"id"`
	Timestamp   time.Time  `json:"timestamp"`
	Host        types.User `json:"host"`
	ViewerCount *int       `json:"hosting_viewer_count"`
}

// HostStart is the activity of when a channel begins hosting another channel.
type HostStart struct {
	ID          string     `json:"id"`
	Timestamp   time.Time  `json:"timestamp"`
	Host        types.User `json:"host"`
	ViewerCount *int       `json:"hosting_viewer_count"`
}

// Raiding is the activity of when a raid status has updated.
type Raiding struct {
	ID          string     `json:"id"`
	Timestamp   time.Time  `json:"timestamp"`
	Raider      types.User `json:"raider"`
	ViewerCount int32      `json:"raiding_viewer_count"`
	Status      int32      `json:"status"`
}

// PrimeResubscriptionSharing is the activity of when a subscriber shares a resubscription (via Twitch Prime) notice in chat.
type PrimeResubscriptionSharing struct {
	ID                     string           `json:"id"`
	Timestamp              time.Time        `json:"timestamp"`
	Subscriber             types.User       `json:"subscriber"`
	Tier                   string           `json:"subscription_tier"`
	CumulativeTenureMonths int              `json:"subscription_cumulative_tenure_months"`
	CustomMessageFragments []types.Fragment `json:"subscription_custom_message_fragments"` // SubscriptionCustomMessageFragments contain metadata to enrich SubscriptionCustomMessageText at specific substrings
	CustomMessageText      string           `json:"subscription_custom_message_text"`      // SubscriptionCustomMessageText is the original message shared by the Subscriber, filtered with moderation rules
	MultiMonthDuration     int              `json:"subscription_multi_month_duration"`
	MultiMonthTenure       int              `json:"subscription_multi_month_tenure"`
}

// PrimeSubscription is the activity of when a user subscribes for the first-time to a channel via Twitch Prime.
type PrimeSubscription struct {
	ID                     string           `json:"id"`
	Timestamp              time.Time        `json:"timestamp"`
	Subscriber             types.User       `json:"subscriber"`
	Tier                   string           `json:"subscription_tier"`
	CumulativeTenureMonths int              `json:"subscription_cumulative_tenure_months"`
	CustomMessageFragments []types.Fragment `json:"subscription_custom_message_fragments"` // SubscriptionCustomMessageFragments contain metadata to enrich SubscriptionCustomMessageText at specific substrings
	CustomMessageText      string           `json:"subscription_custom_message_text"`      // SubscriptionCustomMessageText is the original message shared by the Subscriber, filtered with moderation rules
	MultiMonthDuration     int              `json:"subscription_multi_month_duration"`
	MultiMonthTenure       int              `json:"subscription_multi_month_tenure"`
}

// ResubscriptionSharing is the activity of when a subscriber chooses to share a resubscription notice in chat.
type ResubscriptionSharing struct {
	ID                     string           `json:"id"`
	Timestamp              time.Time        `json:"timestamp"`
	Subscriber             types.User       `json:"subscriber"`
	Tier                   string           `json:"subscription_tier"`
	CumulativeTenureMonths int              `json:"subscription_cumulative_tenure_months"`
	CustomMessageFragments []types.Fragment `json:"subscription_custom_message_fragments"` // SubscriptionCustomMessageFragments contain metadata to enrich SubscriptionCustomMessageText at specific substrings
	CustomMessageText      string           `json:"subscription_custom_message_text"`      // SubscriptionCustomMessageText is the original message shared by the Subscriber, filtered with moderation rules
	MultiMonthDuration     int              `json:"subscription_multi_month_duration"`
	MultiMonthTenure       int              `json:"subscription_multi_month_tenure"`
}

// Subscription is the activity of when a user subscribes for the first-time to a channel via paid option.
type Subscription struct {
	ID                     string           `json:"id"`
	Timestamp              time.Time        `json:"timestamp"`
	Subscriber             types.User       `json:"subscriber"`
	Tier                   string           `json:"subscription_tier"`
	CumulativeTenureMonths int              `json:"subscription_cumulative_tenure_months"`
	CustomMessageFragments []types.Fragment `json:"subscription_custom_message_fragments"` // SubscriptionCustomMessageFragments contain metadata to enrich SubscriptionCustomMessageText at specific substrings
	CustomMessageText      string           `json:"subscription_custom_message_text"`      // SubscriptionCustomMessageText is the original message shared by the Subscriber, filtered with moderation rules
	MultiMonthDuration     int              `json:"subscription_multi_month_duration"`
	MultiMonthTenure       int              `json:"subscription_multi_month_tenure"`
}

// SubscriptionGiftingIndividual is the activity of when a user gifts a single subscription to another user for a channel.
type SubscriptionGiftingIndividual struct {
	ID          string      `json:"id"`
	Timestamp   time.Time   `json:"timestamp"`
	Gifter      *types.User `json:"subscription_gifter"` // nil if SubscriptionGiftAnonymous
	Anonymous   bool        `json:"subscription_gift_anonymous"`
	Recipient   types.User  `json:"subscription_gift_recipient"`
	Tier        string      `json:"subscription_gift_tier"`
	MonthAmount int         `json:"subscription_gift_month_amount"`
}

// SubscriptionGiftingCommunity is the activity of when a user gifts multiple subscriptions to other users for a specific channel.
type SubscriptionGiftingCommunity struct {
	ID           string      `json:"id"`
	Timestamp    time.Time   `json:"timestamp"`
	Gifter       *types.User `json:"subscription_gifter"` // nil if SubscriptionGiftAnonymous
	Anonymous    bool        `json:"subscription_gift_anonymous"`
	GiftQuantity int         `json:"subscription_gift_quantity"`
	Tier         string      `json:"subscription_gift_tier"`
	MonthAmount  int         `json:"subscription_gift_month_amount"`
}

// BoostStart is the activity of when a channel starts getting boosted.
type BoostStart struct {
	ID                     string      `json:"id"`
	Timestamp              time.Time   `json:"timestamp"`
	BoostOrderGoalProgress int         `json:"boost_order_goal_progress"`
	BoostOrderGoalTarget   int         `json:"boost_order_goal_target"`
	BoostOrderQuantity     int         `json:"boost_order_quantity"`
	BoostOrderPurchaser    *types.User `json:"boost_order_purchaser"`
}

// BoostComplete is the activity of when a channel ends getting boosted because goal target has been reached.
type BoostComplete struct {
	ID                     string      `json:"id"`
	Timestamp              time.Time   `json:"timestamp"`
	BoostOrderGoalProgress int         `json:"boost_order_goal_progress"`
	BoostOrderGoalTarget   int         `json:"boost_order_goal_target"`
	BoostOrderQuantity     int         `json:"boost_order_quantity"`
	BoostOrderPurchaser    *types.User `json:"boost_order_purchaser"`
}

// CelebrationPurchase is the activity of when a user has purchased a celebration on a channel.
type CelebrationPurchase struct {
	ID                        string     `json:"id"`
	Timestamp                 time.Time  `json:"timestamp"`
	CelebrationPurchasingUser types.User `json:"celebration_purchasing_user"`
	Intensity                 string     `json:"intensity"`
	Effect                    string     `json:"effect"`
}

// ChannelPointsCustomRewardRedemption is the activity of when a user has redeemed a custom Channel Points reward for a channel.
type ChannelPointsCustomRewardRedemption struct {
	ID            string     `json:"id"`
	Timestamp     time.Time  `json:"timestamp"`
	RedemptionID  string     `json:"channel_points_redemption_id"`
	RedeemingUser types.User `json:"channel_points_redeeming_user"`
	RewardID      string     `json:"channel_points_reward_id"`
	RewardTitle   string     `json:"channel_points_reward_title"`
	UserInput     *string    `json:"channel_points_user_input"` // Expected to be null where the reward doesn't take user input.
}

// CopoGoalEnded is the activity of when a community challenge ends.
type CopoGoalEnded struct {
	ID                             string    `json:"id"`
	Timestamp                      time.Time `json:"timestamp"`
	ChannelPointsGoalID            string    `json:"channel_points_goal_id"`
	ChannelPointsGoalTitle         string    `json:"channel_points_goal_title"`
	ChannelPointsPointsContributed int       `json:"channel_points_points_contributed"`
	ChannelPointsGoalAmount        int       `json:"channel_points_goal_amount"`
	ChannelPointsGoalStatus        string    `json:"channel_points_goal_status"`
	ChannelPointsGoalType          string    `json:"channel_points_goal_type"`
	ChannelPointsName              string    `json:"channel_points_name"`
}

// DropClaimWindowOpen is the activity of when a channel has completed a DropQuest and viewers are now able to claim the drop.
type DropClaimWindowOpen struct {
	ID                string    `json:"id"`
	Timestamp         time.Time `json:"timestamp"`
	DropName          string    `json:"drop_name"`
	DropInstanceID    string    `json:"drop_instance_id"`
	DropQuestName     string    `json:"quest_name"`
	DropClaimDuration int32     `json:"claim_duration"`
}

// HypeTrain is the activity of when a hype train is activated.
type HypeTrain struct {
	ID                      string    `json:"id"`
	Timestamp               time.Time `json:"timestamp"`
	HypeTrainID             string    `json:"hype_train_id"`
	HypeTrainEventType      string    `json:"hype_train_event_type"`
	HypeTrainCompletedLevel *int      `json:"hype_train_completed_level"`
	HypeTrainTotalSubs      *int      `json:"hype_train_total_subs"`
	HypeTrainTotalBits      *int      `json:"hype_train_total_bits"`
}
