// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2021-03-15 11:26:13.496826 -0700 PDT m=+0.031699493
// Template path: handler_definitions/templates/internal/clients/pubsub/publish.go.tmpl

package pubsub

import (
	"context"

	"code.justin.tv/cb/sauron/activity"
	"code.justin.tv/cb/sauron/activity/pubsub"
)

// Publisher contains the methods for publishing events to pubsub.
type Publisher interface {
	PublishBitsUsage(ctx context.Context, channelID string, data BitsUsage, alertStatus string) error
	PublishFollow(ctx context.Context, channelID string, data Follow, alertStatus string) error
	PublishAutoHostStart(ctx context.Context, channelID string, data AutoHostStart, alertStatus string) error
	PublishHostStart(ctx context.Context, channelID string, data HostStart, alertStatus string) error
	PublishRaiding(ctx context.Context, channelID string, data Raiding, alertStatus string) error
	PublishPrimeResubscriptionSharing(ctx context.Context, channelID string, data PrimeResubscriptionSharing, alertStatus string) error
	PublishPrimeSubscription(ctx context.Context, channelID string, data PrimeSubscription, alertStatus string) error
	PublishResubscriptionSharing(ctx context.Context, channelID string, data ResubscriptionSharing, alertStatus string) error
	PublishSubscription(ctx context.Context, channelID string, data Subscription, alertStatus string) error
	PublishSubscriptionGiftingIndividual(ctx context.Context, channelID string, data SubscriptionGiftingIndividual, alertStatus string) error
	PublishSubscriptionGiftingCommunity(ctx context.Context, channelID string, data SubscriptionGiftingCommunity, alertStatus string) error
	PublishBoostStart(ctx context.Context, channelID string, data BoostStart) error
	PublishBoostComplete(ctx context.Context, channelID string, data BoostComplete) error
	PublishCelebrationPurchase(ctx context.Context, channelID string, data CelebrationPurchase) error
	PublishChannelPointsCustomRewardRedemption(ctx context.Context, channelID string, data ChannelPointsCustomRewardRedemption) error
	PublishCopoGoalEnded(ctx context.Context, channelID string, data CopoGoalEnded) error
	PublishDropClaimWindowOpen(ctx context.Context, channelID string, data DropClaimWindowOpen) error
	PublishHypeTrain(ctx context.Context, channelID string, data HypeTrain) error
	PublishAlert(ctx context.Context, channelID string, alert Alert) error
}

// PublishBitsUsage publishes a BitsUsage activity to Pubsub.
func (c *Client) PublishBitsUsage(ctx context.Context, channelID string, data BitsUsage, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:            data.ID,
		Timestamp:     data.Timestamp,
		Type:          activity.TypeBitsUsage,
		BitsAmount:    &data.Amount,
		BitsAnonymous: &data.Anonymous,
		BitsUser:      data.User.IfNotAnonymous(data.Anonymous),
		AlertStatus:   &alertStatus,
	})
}

// PublishFollow publishes a Follow activity to Pubsub.
func (c *Client) PublishFollow(ctx context.Context, channelID string, data Follow, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:          data.ID,
		Timestamp:   data.Timestamp,
		Type:        activity.TypeFollow,
		Follower:    &data.Follower,
		AlertStatus: &alertStatus,
	})
}

// PublishAutoHostStart publishes a AutoHostStart activity to Pubsub.
func (c *Client) PublishAutoHostStart(ctx context.Context, channelID string, data AutoHostStart, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                 data.ID,
		Timestamp:          data.Timestamp,
		Type:               activity.TypeAutoHostStart,
		Host:               &data.Host,
		HostingViewerCount: data.ViewerCount,
		AlertStatus:        &alertStatus,
	})
}

// PublishHostStart publishes a HostStart activity to Pubsub.
func (c *Client) PublishHostStart(ctx context.Context, channelID string, data HostStart, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                 data.ID,
		Timestamp:          data.Timestamp,
		Type:               activity.TypeHostStart,
		Host:               &data.Host,
		HostingViewerCount: data.ViewerCount,
		AlertStatus:        &alertStatus,
	})
}

// PublishRaiding publishes a Raiding activity to Pubsub.
func (c *Client) PublishRaiding(ctx context.Context, channelID string, data Raiding, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                 data.ID,
		Timestamp:          data.Timestamp,
		Type:               activity.TypeRaiding,
		Raider:             &data.Raider,
		RaidingViewerCount: &data.ViewerCount,
		Status:             &data.Status,
		AlertStatus:        &alertStatus,
	})
}

// PublishPrimeResubscriptionSharing publishes a PrimeResubscriptionSharing activity to Pubsub.
func (c *Client) PublishPrimeResubscriptionSharing(ctx context.Context, channelID string, data PrimeResubscriptionSharing, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                                 data.ID,
		Timestamp:                          data.Timestamp,
		Type:                               activity.TypePrimeResubscriptionSharing,
		Subscriber:                         &data.Subscriber,
		SubscriptionCumulativeTenureMonths: &data.CumulativeTenureMonths,
		SubscriptionCustomMessageFragments: data.CustomMessageFragments,
		SubscriptionCustomMessageText:      &data.CustomMessageText,
		SubscriptionMultiMonthDuration:     &data.MultiMonthDuration,
		SubscriptionMultiMonthTenure:       &data.MultiMonthTenure,
		AlertStatus:                        &alertStatus,
	})
}

// PublishPrimeSubscription publishes a PrimeSubscription activity to Pubsub.
func (c *Client) PublishPrimeSubscription(ctx context.Context, channelID string, data PrimeSubscription, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:          data.ID,
		Timestamp:   data.Timestamp,
		Type:        activity.TypePrimeSubscription,
		Subscriber:  &data.Subscriber,
		AlertStatus: &alertStatus,
	})
}

// PublishResubscriptionSharing publishes a ResubscriptionSharing activity to Pubsub.
func (c *Client) PublishResubscriptionSharing(ctx context.Context, channelID string, data ResubscriptionSharing, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                                 data.ID,
		Timestamp:                          data.Timestamp,
		Type:                               activity.TypeResubscriptionSharing,
		Subscriber:                         &data.Subscriber,
		SubscriptionTier:                   &data.Tier,
		SubscriptionCumulativeTenureMonths: &data.CumulativeTenureMonths,
		SubscriptionCustomMessageFragments: data.CustomMessageFragments,
		SubscriptionCustomMessageText:      &data.CustomMessageText,
		SubscriptionMultiMonthDuration:     &data.MultiMonthDuration,
		SubscriptionMultiMonthTenure:       &data.MultiMonthTenure,
		AlertStatus:                        &alertStatus,
	})
}

// PublishSubscription publishes a Subscription activity to Pubsub.
func (c *Client) PublishSubscription(ctx context.Context, channelID string, data Subscription, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                             data.ID,
		Timestamp:                      data.Timestamp,
		Type:                           activity.TypeSubscription,
		Subscriber:                     &data.Subscriber,
		SubscriptionTier:               &data.Tier,
		SubscriptionMultiMonthDuration: &data.MultiMonthDuration,
		SubscriptionMultiMonthTenure:   &data.MultiMonthTenure,
		AlertStatus:                    &alertStatus,
	})
}

// PublishSubscriptionGiftingIndividual publishes a SubscriptionGiftingIndividual activity to Pubsub.
func (c *Client) PublishSubscriptionGiftingIndividual(ctx context.Context, channelID string, data SubscriptionGiftingIndividual, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                          data.ID,
		Timestamp:                   data.Timestamp,
		Type:                        activity.TypeSubscriptionGiftingIndividual,
		SubscriptionGifter:          data.Gifter.IfNotAnonymous(data.Anonymous),
		SubscriptionGiftAnonymous:   &data.Anonymous,
		SubscriptionGiftRecipient:   &data.Recipient,
		SubscriptionGiftTier:        &data.Tier,
		SubscriptionGiftMonthAmount: &data.MonthAmount,
		AlertStatus:                 &alertStatus,
	})
}

// PublishSubscriptionGiftingCommunity publishes a SubscriptionGiftingCommunity activity to Pubsub.
func (c *Client) PublishSubscriptionGiftingCommunity(ctx context.Context, channelID string, data SubscriptionGiftingCommunity, alertStatus string) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                          data.ID,
		Timestamp:                   data.Timestamp,
		Type:                        activity.TypeSubscriptionGiftingCommunity,
		SubscriptionGifter:          data.Gifter.IfNotAnonymous(data.Anonymous),
		SubscriptionGiftAnonymous:   &data.Anonymous,
		SubscriptionGiftQuantity:    &data.GiftQuantity,
		SubscriptionGiftTier:        &data.Tier,
		SubscriptionGiftMonthAmount: &data.MonthAmount,
		AlertStatus:                 &alertStatus,
	})
}

// PublishBoostStart publishes a BoostStart activity to Pubsub.
func (c *Client) PublishBoostStart(ctx context.Context, channelID string, data BoostStart) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                     data.ID,
		Timestamp:              data.Timestamp,
		Type:                   activity.TypeBoostStart,
		BoostOrderGoalProgress: &data.BoostOrderGoalProgress,
		BoostOrderGoalTarget:   &data.BoostOrderGoalTarget,
		BoostOrderQuantity:     &data.BoostOrderQuantity,
		BoostOrderPurchaser:    data.BoostOrderPurchaser,
	})
}

// PublishBoostComplete publishes a BoostComplete activity to Pubsub.
func (c *Client) PublishBoostComplete(ctx context.Context, channelID string, data BoostComplete) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                     data.ID,
		Timestamp:              data.Timestamp,
		Type:                   activity.TypeBoostComplete,
		BoostOrderGoalProgress: &data.BoostOrderGoalProgress,
		BoostOrderGoalTarget:   &data.BoostOrderGoalTarget,
		BoostOrderQuantity:     &data.BoostOrderQuantity,
		BoostOrderPurchaser:    data.BoostOrderPurchaser,
	})
}

// PublishCelebrationPurchase publishes a CelebrationPurchase activity to Pubsub.
func (c *Client) PublishCelebrationPurchase(ctx context.Context, channelID string, data CelebrationPurchase) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                        data.ID,
		Timestamp:                 data.Timestamp,
		Type:                      activity.TypeCelebrationPurchase,
		CelebrationPurchasingUser: &data.CelebrationPurchasingUser,
		Intensity:                 &data.Intensity,
		Effect:                    &data.Effect,
	})
}

// PublishChannelPointsCustomRewardRedemption publishes a ChannelPointsCustomRewardRedemption activity to Pubsub.
func (c *Client) PublishChannelPointsCustomRewardRedemption(ctx context.Context, channelID string, data ChannelPointsCustomRewardRedemption) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                         data.ID,
		Timestamp:                  data.Timestamp,
		Type:                       activity.TypeChannelPointsCustomRewardRedemption,
		ChannelPointsRedemptionID:  &data.RedemptionID,
		ChannelPointsRedeemingUser: &data.RedeemingUser,
		ChannelPointsRewardID:      &data.RewardID,
		ChannelPointsRewardTitle:   &data.RewardTitle,
		ChannelPointsUserInput:     data.UserInput,
	})
}

// PublishCopoGoalEnded publishes a CopoGoalEnded activity to Pubsub.
func (c *Client) PublishCopoGoalEnded(ctx context.Context, channelID string, data CopoGoalEnded) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                             data.ID,
		Timestamp:                      data.Timestamp,
		Type:                           activity.TypeCopoGoalEnded,
		ChannelPointsGoalID:            &data.ChannelPointsGoalID,
		ChannelPointsGoalTitle:         &data.ChannelPointsGoalTitle,
		ChannelPointsPointsContributed: &data.ChannelPointsPointsContributed,
		ChannelPointsGoalAmount:        &data.ChannelPointsGoalAmount,
		ChannelPointsGoalStatus:        &data.ChannelPointsGoalStatus,
		ChannelPointsGoalType:          &data.ChannelPointsGoalType,
		ChannelPointsName:              &data.ChannelPointsName,
	})
}

// PublishDropClaimWindowOpen publishes a DropClaimWindowOpen activity to Pubsub.
func (c *Client) PublishDropClaimWindowOpen(ctx context.Context, channelID string, data DropClaimWindowOpen) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                data.ID,
		Timestamp:         data.Timestamp,
		Type:              activity.TypeDropClaimWindowOpen,
		DropName:          &data.DropName,
		DropInstanceID:    &data.DropInstanceID,
		DropQuestName:     &data.DropQuestName,
		DropClaimDuration: &data.DropClaimDuration,
	})
}

// PublishHypeTrain publishes a HypeTrain activity to Pubsub.
func (c *Client) PublishHypeTrain(ctx context.Context, channelID string, data HypeTrain) error {
	return c.publish(ctx, channelID, pubsub.Activity{
		ID:                      data.ID,
		Timestamp:               data.Timestamp,
		Type:                    activity.TypeHypeTrain,
		HypeTrainID:             &data.HypeTrainID,
		HypeTrainEventType:      &data.HypeTrainEventType,
		HypeTrainCompletedLevel: data.HypeTrainCompletedLevel,
		HypeTrainTotalSubs:      data.HypeTrainTotalSubs,
		HypeTrainTotalBits:      data.HypeTrainTotalBits,
	})
}
