package stats

import (
	"context"
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

// NoopClient is the statsd client that does nothing
type NoopClient struct {
	statsd.NoopClient
}

// NewNoopClient creates a new statsd that does nothing
func NewNoopClient() *NoopClient {
	return &NoopClient{
		NoopClient: statsd.NoopClient{},
	}
}

// ExecutionTime does nothing
func (c *NoopClient) ExecutionTime(statName string, duration time.Duration) {}

// GoExecutionTime does nothing
func (c *NoopClient) GoExecutionTime(statName string, duration time.Duration) {}

// Increment does nothing.
func (c *NoopClient) Increment(statName string, value int64) {}

// GoIncrement does nothing.
func (c *NoopClient) GoIncrement(statName string, value int64) {}

// SendGauge does nothing.
func (c *NoopClient) SendGauge(statName string, value int64) {}

// GoOther does nothing.
func (c *NoopClient) GoOther(callback func()) {}

// Shutdown does nothing.
func (c *NoopClient) Shutdown(ctx context.Context) error { return nil }
