package errors

import "github.com/twitchtv/twirp"

const (
	errGQLMetaKey = "gql_code"
)

var (
	ErrActivityNotFound     = twirp.NotFoundError("activity not found").WithMeta(errGQLMetaKey, "NOT_FOUND")
	ErrMissingActivityID    = twirp.RequiredArgumentError("activityID").WithMeta(errGQLMetaKey, "INVALID_ACTIVITY_ID")
	ErrInvalidAlertStatus   = twirp.InvalidArgumentError("alert_status", "must be one of queued, playing, played, skipped, rejected, failed, and offline").WithMeta(errGQLMetaKey, "INVALID_ALERT_STATUS")
	ErrMissingChannelID     = twirp.RequiredArgumentError("channelID").WithMeta(errGQLMetaKey, "INVALID_CHANNEL_ID")
	ErrInvalidChannelID     = twirp.InvalidArgumentError("channelID", "must be valid").WithMeta(errGQLMetaKey, "INVALID_CHANNEL_ID")
	ErrInvalidCursor        = twirp.InvalidArgumentError("cursor", "must be valid").WithMeta(errGQLMetaKey, "INVALID_CURSOR")
	ErrInvalidLimit         = twirp.InvalidArgumentError("limit", "must be a non-negative integer").WithMeta(errGQLMetaKey, "INVALID_LIMIT")
	ErrInvalidPreferenceKey = twirp.InvalidArgumentError("key",
		"must be one of dnd_mode_enabled, hide_follows, hide_hosts, hide_raids, hide_bits, hide_subscriptions, or hide_gift_subscriptions").WithMeta(errGQLMetaKey, "INVALID_PREFERENCE")
)
