// Code generated by sauron/cmd/codegen; DO NOT EDIT.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-05-08 16:30:29.050931 -0700 PDT m=+0.094879459
// Template path: handler_definitions/templates/internal/event/{name}/handler.go.tmpl

package bitsusage

import (
	"context"

	"code.justin.tv/cb/sauron/internal/clients/users"
	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
)

func (h Handler) processMessage(ctx context.Context, sqsMessage events.SQSMessage) error {
	logger := log.WithField("message_body", sqsMessage.Body)

	msg, err := convert(sqsMessage)
	if err != nil {
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if err := validate(msg); err != nil {
		h.Statsd.GoIncrement(validateErrorStat, 1)
		logger.WithError(err).Warn("bitsusage: failed to validate message")
		return nil
	}
	user, err := h.Users.GetUser(ctx, msg.UserID)
	if err != nil {
		switch err {
		case users.ErrUserNotFound:
			h.Statsd.GoIncrement(userNotFoundStat, 1)
			logger.Warnf("bitsusage: User not found for user id '%s'", msg.UserID)
			return nil
		default:
			h.Statsd.GoIncrement(errorStat, 1)
			logger.WithError(err).Errorf("bitsusage: failed to fetch User with user id '%s'", msg.UserID)
			return err
		}
	}

	logger = log.WithFields(log.Fields{
		"bitsusage_msg": msg,
		"user":          user,
	})
	return h.insertAndPublishBitsUsage(ctx, logger, msg.Timestamp, msg.ChannelID, msg.Amount, msg.IsAnonymous, user)
}
