// Code generated by sauron/cmd/codegen; DO NOT EDIT.
// This file was generated by robots at
// 2020-10-19 16:28:20.015553 -0700 PDT m=+0.136487934
// Template path: handler_definitions/templates/internal/event/{name}/generated.go.tmpl

package boosts

import (
	"context"
	"encoding/json"
	"time"

	"code.justin.tv/cb/sauron/internal/clients/dynamodb"
	"code.justin.tv/cb/sauron/internal/clients/pubsub"
	"code.justin.tv/cb/sauron/internal/clients/stats"
	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/types"
	"github.com/aws/aws-lambda-go/events"
	"github.com/gofrs/uuid"
	log "github.com/sirupsen/logrus"
)

const (
	statPrefix        = "event.boosts."
	durationStat      = statPrefix + "duration"
	errorStat         = statPrefix + "error"
	successStat       = statPrefix + "success"
	validateErrorStat = statPrefix + "validate_error"
	userNotFoundStat  = statPrefix + "user_not_found"
)

// Handler implements github.com/aws/aws-lambda-go/lambda.Handler.
type Handler struct {
	DynamoDB dynamodb.Database
	Pubsub   pubsub.Publisher
	Users    users.Users
	Statsd   stats.StatSender
}

// Invoke allows Handler to implement github.com/aws/aws-lambda-go/lambda.Handler.
func (h Handler) Invoke(ctx context.Context, payload []byte) ([]byte, error) {
	start := time.Now()
	defer func() {
		since := time.Since(start)
		h.Statsd.GoExecutionTime(durationStat, since)
		cancelCtx, cancel := context.WithTimeout(ctx, 5*time.Second)
		defer cancel()
		if err := h.Statsd.Shutdown(cancelCtx); err != nil {
			log.WithError(err).Warn("timeout before statsd finished")
		}
	}()

	logger := log.WithField("payload", string(payload))

	var event events.SQSEvent

	if err := json.Unmarshal(payload, &event); err != nil {
		logger.WithError(err).Warn("invalid json payload")

		return nil, err
	}

	if len(event.Records) == 0 {
		logger.Warn("no records in sqs event")

		return nil, nil
	}

	for _, record := range event.Records {
		if err := h.processMessage(ctx, record); err != nil {
			return nil, err
		}
	}

	return nil, nil
}

// convert takes in an sqs message and unmarshals it to the proper follow message we need
// for processing. We need to unmarshal twice: first to get the message body, which contains
// the follow message as a json string, and then secondly to unmarshal that json string.
func convert(sqsMessage events.SQSMessage) (Message, error) {
	var sqsBody events.SNSEntity
	if err := json.Unmarshal([]byte(sqsMessage.Body), &sqsBody); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("boosts: invalid json body in sqs message")
		return Message{}, err
	}

	var msg Message
	if err := json.Unmarshal([]byte(sqsBody.Message), &msg); err != nil {
		log.WithField("message_body", sqsMessage.Body).WithError(err).Warn("boosts: invalid json message in sns message")
		return Message{}, err
	}
	msg.Timestamp = sqsBody.Timestamp

	return msg, nil
}

func (h *Handler) insertAndPublishBoostStart(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	boostOrderGoalProgress int, boostOrderGoalTarget int, boostOrderQuantity int, boostOrderPurchaser *types.User) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("boosts: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	var boostOrderPurchaserID *string
	if boostOrderPurchaser != nil {
		boostOrderPurchaserID = &boostOrderPurchaser.ID
	}

	err = h.DynamoDB.InsertBoostStart(ctx, channelID, dynamodb.BoostStart{
		ID:                     id.String(),
		Timestamp:              timestamp,
		BoostOrderGoalProgress: boostOrderGoalProgress,
		BoostOrderGoalTarget:   boostOrderGoalTarget,
		BoostOrderQuantity:     boostOrderQuantity,
		BoostOrderPurchaserID:  boostOrderPurchaserID,
	})
	if err != nil {
		logger.WithError(err).Error("boosts: failed to insert 'boost_start' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.BoostStart{
		ID:                     id.String(),
		Timestamp:              timestamp,
		BoostOrderGoalProgress: boostOrderGoalProgress,
		BoostOrderGoalTarget:   boostOrderGoalTarget,
		BoostOrderQuantity:     boostOrderQuantity,
		BoostOrderPurchaser:    boostOrderPurchaser,
	}
	err = h.Pubsub.PublishBoostStart(ctx, channelID, pubsubMsg)
	if err != nil {
		logger.WithError(err).Error("boosts: failed to publish 'boost_start' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}

func (h *Handler) insertAndPublishBoostComplete(ctx context.Context, logger *log.Entry, timestamp time.Time, channelID string,
	boostOrderGoalProgress int, boostOrderGoalTarget int, boostOrderQuantity int, boostOrderPurchaser *types.User) error {
	id, err := uuid.NewV4()
	if err != nil {
		logger.WithError(err).Error("boosts: unable to generate UUID")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	var boostOrderPurchaserID *string
	if boostOrderPurchaser != nil {
		boostOrderPurchaserID = &boostOrderPurchaser.ID
	}

	err = h.DynamoDB.InsertBoostComplete(ctx, channelID, dynamodb.BoostComplete{
		ID:                     id.String(),
		Timestamp:              timestamp,
		BoostOrderGoalProgress: boostOrderGoalProgress,
		BoostOrderGoalTarget:   boostOrderGoalTarget,
		BoostOrderQuantity:     boostOrderQuantity,
		BoostOrderPurchaserID:  boostOrderPurchaserID,
	})
	if err != nil {
		logger.WithError(err).Error("boosts: failed to insert 'boost_complete' activity into dynamodb")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	pubsubMsg := pubsub.BoostComplete{
		ID:                     id.String(),
		Timestamp:              timestamp,
		BoostOrderGoalProgress: boostOrderGoalProgress,
		BoostOrderGoalTarget:   boostOrderGoalTarget,
		BoostOrderQuantity:     boostOrderQuantity,
		BoostOrderPurchaser:    boostOrderPurchaser,
	}
	err = h.Pubsub.PublishBoostComplete(ctx, channelID, pubsubMsg)
	if err != nil {
		logger.WithError(err).Error("boosts: failed to publish 'boost_complete' activity to pubsub")
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	h.Statsd.GoIncrement(successStat, 1)
	return nil
}
