// Code generated by sauron/cmd/codegen; EDITED.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-10-15 10:07:41.516813 -0700 PDT m=+0.048930623
// Template path: handler_definitions/templates/internal/event/{name}/handler.go.tmpl

package boosts

import (
	"context"

	"code.justin.tv/cb/sauron/internal/clients/users"
	"code.justin.tv/cb/sauron/types"
	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
)

const (
	BOOST_START_MESSAGE_TYPE    = "BOOST_START"
	BOOST_COMPLETE_MESSAGE_TYPE = "BOOST_COMPLETE"
)

func (h Handler) processMessage(ctx context.Context, sqsMessage events.SQSMessage) error {
	logger := log.WithField("message_body", sqsMessage.Body)
	msg, err := convert(sqsMessage)
	if err != nil {
		h.Statsd.GoIncrement(errorStat, 1)
		return err
	}

	if err := validate(msg); err != nil {
		h.Statsd.GoIncrement(validateErrorStat, 1)
		logger.WithError(err).Warn("boosts: failed to validate message")
		return nil
	}

	var user *types.User
	if msg.PurchaserID != nil && *msg.PurchaserID != "" {
		userResp, err := h.Users.GetUser(ctx, *msg.PurchaserID)
		user = &userResp
		if err != nil {
			switch err {
			case users.ErrUserNotFound:
				h.Statsd.GoIncrement(userNotFoundStat, 1)
				logger.Warnf("boosts: BoostPurchaser not found for user id '%s'", *msg.PurchaserID)
				return nil
			default:
				h.Statsd.GoIncrement(errorStat, 1)
				logger.WithError(err).Errorf("boosts: failed to fetch BoostPurchaser with user id '%s'", *msg.PurchaserID)
				return err
			}
		}
	}

	logger = log.WithFields(log.Fields{
		"boosts_msg": msg,
		"purchaser":  user,
	})
	switch msg.MessageType {
	case BOOST_START_MESSAGE_TYPE:
		return h.insertAndPublishBoostStart(ctx, logger, msg.Timestamp, msg.ChannelID, msg.GoalProgress, msg.GoalTarget, msg.Quantity, user)
	case BOOST_COMPLETE_MESSAGE_TYPE:
		return h.insertAndPublishBoostComplete(ctx, logger, msg.Timestamp, msg.ChannelID, msg.GoalProgress, msg.GoalTarget, msg.Quantity, user)
	default:
		return nil
	}
}
