// Code generated by sauron/cmd/codegen; EDITED.
//
// NOTE: You may need to hand edit this file!
//       If so, change the first line from DO NOT EDIT to EDITED (or delete
//       this entire comment block)! After that, the code generator will no
//       longer update this file, so be sure to keep it up to date.
//
// This file was generated by robots at
// 2020-10-14 15:38:26.201092 -0700 PDT m=+0.054462696
// Template path: handler_definitions/templates/internal/event/{name}/handler_test.go.tmpl

package boosts_test

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"testing"
	"time"

	"code.justin.tv/cb/sauron/internal/event/boosts"
	"code.justin.tv/cb/sauron/internal/mocks"
	"code.justin.tv/cb/sauron/types"

	"github.com/aws/aws-lambda-go/events"
	log "github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
	"github.com/stretchr/testify/mock"
)

type mockHandlerParams struct {
	DynamoDB *mocks.Database
	Pubsub   *mocks.Publisher
	Users    *mocks.Users
	Statsd   *mocks.StatSender
}

func handlerMocks() mockHandlerParams {
	return mockHandlerParams{
		DynamoDB: &mocks.Database{},
		Pubsub:   &mocks.Publisher{},
		Users:    &mocks.Users{},
		Statsd:   &mocks.StatSender{},
	}
}

func mockHandler(params mockHandlerParams) *boosts.Handler {
	return &boosts.Handler{
		DynamoDB: params.DynamoDB,
		Pubsub:   params.Pubsub,
		Users:    params.Users,
		Statsd:   params.Statsd,
	}
}

func getInvokeInput(channelID string, goalProgress int, goalTarget int, quantity int, purchaserID *string, messageType string) []byte {
	msg := boosts.Message{
		Timestamp:    time.Now(),
		ChannelID:    channelID,
		GoalProgress: goalProgress,
		GoalTarget:   goalTarget,
		Quantity:     quantity,
		PurchaserID:  purchaserID,
		MessageType:  messageType,
	}

	msgBytes, _ := json.Marshal(msg)

	snsEntity := events.SNSEntity{
		Message: string(msgBytes),
	}

	snsEntityBytes, _ := json.Marshal(snsEntity)

	sqsMessage := events.SQSMessage{
		Body: string(snsEntityBytes),
	}
	records := make([]events.SQSMessage, 1, 1)
	records[0] = sqsMessage
	input := events.SQSEvent{
		Records: records,
	}

	inputBytes := new(bytes.Buffer)
	_ = json.NewEncoder(inputBytes).Encode(input)
	return inputBytes.Bytes()
}

func TestInvokeWithInvalidInput(t *testing.T) {
	log.SetLevel(log.PanicLevel)
	m := handlerMocks()
	handler := mockHandler(m)
	ctx := context.Background()
	m.Statsd.On("GoIncrement", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("GoExecutionTime", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("Shutdown", mock.Anything).Return(nil)

	channelId := "channel-id"
	goalProgress := 0
	goalTarget := 100
	quantity := 1
	purchaserId := "222222"
	messageType := "BOOST_START"

	Convey("When the handler is invoked with invalid input", t, func() {
		Convey("When the sqs payload contains invalid json", func() {
			Convey("It should return an error", func() {
				invalidSqs := []byte("{\"Records\":}")
				result, err := handler.Invoke(ctx, invalidSqs)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})

		})

		Convey("When the sqs payload has no messages", func() {
			Convey("It should return nil", func() {
				sqs := []byte("{\"Records\":[]}")
				result, err := handler.Invoke(ctx, sqs)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})

		Convey("When the sqs message has invalid json", func() {
			Convey("It should return an error", func() {
				sqs := []byte("{\"Records\":[{\"messageId\":]}")
				result, err := handler.Invoke(ctx, sqs)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})

		Convey("When target channel is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput("", goalProgress, goalTarget, quantity, &purchaserId, messageType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When goal target is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalProgress, 0, quantity, &purchaserId, messageType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When quantity is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalProgress, goalTarget, 0, &purchaserId, messageType)
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When message type is missing", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, "")
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
		Convey("When message type is invalid", func() {
			Convey("It should return a nil result and nil error", func() {
				input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, "alskdjf")
				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldBeNil)
			})
		})
	})
}

func TestInvokeWithValidInput(t *testing.T) {
	log.SetLevel(log.PanicLevel)
	m := handlerMocks()
	handler := mockHandler(m)
	ctx := context.Background()
	m.Statsd.On("GoIncrement", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("GoExecutionTime", mock.Anything, mock.Anything).Maybe()
	m.Statsd.On("Shutdown", mock.Anything).Return(nil)

	channelId := "channel-id"
	goalProgress := 0
	goalTarget := 100
	quantity := 1
	purchaserId := "222222"
	messageType := "BOOST_START"

	Convey("When the handler is invoked with a valid input", t, func() {
		Convey("When user service fails", func() {
			Convey("It should return a nil result and an error", func() {
				input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, messageType)
				m.Users.On("GetUser", ctx, purchaserId).Once().Return(types.User{}, errors.New("users service failed"))

				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})

		Convey("When inserting fails", func() {
			Convey("It should return a nil result and an error, and not publish", func() {
				input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, messageType)
				m.Users.On("GetUser", ctx, purchaserId).Once().Return(types.User{ID: purchaserId, Login: "test", DisplayName: "test"}, nil)
				m.DynamoDB.On("InsertBoostStart", ctx, mock.Anything, mock.Anything).Once().Return(errors.New("dynamo failed"))

				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)

				m.Pubsub.AssertNotCalled(t, "PublishBoostStart", ctx, mock.Anything, mock.Anything, mock.Anything)
			})
		})

		Convey("When publishing to pubsub fails", func() {
			Convey("It should return a nil result and an error", func() {
				input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, messageType)
				m.Users.On("GetUser", ctx, purchaserId).Once().Return(types.User{ID: purchaserId, Login: "test", DisplayName: "test"}, nil)
				m.DynamoDB.On("InsertBoostStart", ctx, mock.Anything, mock.Anything).Once().Return(nil)
				m.Pubsub.On("PublishBoostStart", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(errors.New("pubsub failed"))

				result, err := handler.Invoke(ctx, input)
				So(result, ShouldBeNil)
				So(err, ShouldNotBeNil)
			})
		})

		Convey("When no call failures", func() {
			Convey("When valid purchaser id", func() {
				Convey("It should return a nil result and no error", func() {
					input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, messageType)
					m.Users.On("GetUser", ctx, purchaserId).Once().Return(types.User{ID: purchaserId, Login: "test", DisplayName: "test"}, nil)
					m.DynamoDB.On("InsertBoostStart", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishBoostStart", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)
				})
			})

			Convey("When nil purchaser Id", func() {
				Convey("It should return a nil result and no error", func() {
					input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, nil, messageType)
					m.DynamoDB.On("InsertBoostStart", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishBoostStart", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)

					m.Users.AssertNotCalled(t, "GetUser", ctx, nil)
				})
			})

			Convey("When empty purchaser Id", func() {
				Convey("It should return a nil result and no error", func() {
					purchaserId = ""
					input := getInvokeInput(channelId, goalProgress, goalTarget, quantity, &purchaserId, messageType)
					m.DynamoDB.On("InsertBoostStart", ctx, mock.Anything, mock.Anything).Once().Return(nil)
					m.Pubsub.On("PublishBoostStart", ctx, mock.Anything, mock.Anything, mock.Anything).Once().Return(nil)

					result, err := handler.Invoke(ctx, input)
					So(result, ShouldBeNil)
					So(err, ShouldBeNil)

					m.Users.AssertNotCalled(t, "GetUser", ctx, purchaserId)
				})
			})
		})
	})
}
